import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {
  AbstractControl,
  FormBuilder,
  FormGroup,
  Validators,
} from "@angular/forms";
import {MatDialogRef} from "@angular/material/dialog";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {SharedNotificationState} from "@shared/stores/notification/shared-notification.state";
import {Observable} from "rxjs";
import {
  FormValidationHelper,
  MemoizedUtil,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-home-preservation-space-organizational-unit-request-access-dialog",
  templateUrl: "./home-archive-restricted-request-access-dialog.component.html",
  styleUrls: ["./home-archive-restricted-request-access-dialog.component.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class HomeArchiveRestrictedRequestAccessDialog extends SharedAbstractContainer implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, SharedNotificationState);

  form: FormGroup;
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _dialogRef: MatDialogRef<HomeArchiveRestrictedRequestAccessDialog>,
              private readonly _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.form = this._fb.group({
      [this.formDefinition.message]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  close(): void {
    this._dialogRef.close();
  }

  onSubmit(): void {
    this._dialogRef.close(this.form.get(this.formDefinition.message).value);
  }

  getFormControl(key: string): AbstractControl {
    return FormValidationHelper.getFormControl(this.form, key);
  }

  get formValidationHelper(): typeof FormValidationHelper {
    return FormValidationHelper;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() message: string;
}
