import {Injectable} from "@angular/core";
import {PreIngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {depositStatusHistoryNamespace} from "@deposit/stores/status-history/deposit-status-history.action";
import {Deposit} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface DepositStatusHistoryStateModel extends StatusHistoryStateModel<Deposit> {
}

@Injectable()
@State<DepositStatusHistoryStateModel>({
  name: LocalStateEnum.deposit_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class DepositStatusHistoryState extends StatusHistoryState<DepositStatusHistoryStateModel, Deposit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.deposits;
  }
}
