import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Person} from "@models";
import {
  AssociationRemoteAction,
  AssociationRemoteNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";

const state = LocalStateEnum.deposit_person;

export namespace DepositPersonAction {

  @TypeDefaultAction(state)
  export class GetAll extends AssociationRemoteAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends AssociationRemoteAction.GetAllSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends AssociationRemoteAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends AssociationRemoteAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends AssociationRemoteAction.GetByIdSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends AssociationRemoteAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends AssociationRemoteAction.Update {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends AssociationRemoteAction.UpdateSuccess {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends AssociationRemoteAction.UpdateFail {
  }

  @TypeDefaultAction(state)
  export class Create extends AssociationRemoteAction.Create {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends AssociationRemoteAction.CreateSuccess {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends AssociationRemoteAction.CreateFail {
  }

  @TypeDefaultAction(state)
  export class Delete extends AssociationRemoteAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends AssociationRemoteAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends AssociationRemoteAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class DeleteList extends AssociationRemoteAction.DeleteList {
  }

  @TypeDefaultAction(state)
  export class DeleteListSuccess extends AssociationRemoteAction.DeleteListSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteListFail extends AssociationRemoteAction.DeleteListFail {
  }
}

export const depositPersonActionNameSpace: AssociationRemoteNameSpace = DepositPersonAction;
