import {Injectable} from "@angular/core";
import {depositPersonActionNameSpace} from "@app/features/deposit/stores/people/deposit-person.action";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {PreIngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Person} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  AssociationRemoteState,
  AssociationRemoteStateModel,
  defaultAssociationRemoteStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface DepositPersonStateModel extends AssociationRemoteStateModel<Person> {
}

@Injectable()
@State<DepositPersonStateModel>({
  name: LocalStateEnum.deposit_person,
  defaults: {
    ...defaultAssociationRemoteStateInitValue(),
  },
})
export class DepositPeopleState extends AssociationRemoteState<DepositPersonStateModel, Person> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositPersonActionNameSpace,
      resourceName: ApiResourceNameEnum.CONTRIBUTOR,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.deposits;
  }
}
