import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {
  defaultDepositOrganizationalUnitAdditionalFieldsFormStateModel,
  DepositOrganizationalUnitAdditionalFieldsFormState,
  DepositOrganizationalUnitAdditionalFieldsFormStateModel,
} from "@deposit/stores/organizational-unit/additional-fields-form/deposit-organizational-unit-additional-fields-form.state";
import {
  DepositOrganizationalUnitAction,
  depositOrganizationalUnitNameSpace,
} from "@deposit/stores/organizational-unit/deposit-organizational-unit.action";
import {OrganizationalUnit} from "@models";
import {
  Action,
  Actions,
  Selector,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {ResourceLogoStateModel} from "@shared/stores/resource-logo/resource-logo-state.model";
import {
  defaultResourceLogoStateInitValue,
  ResourceLogoState,
  ResourceLogoStateModeEnum,
} from "@shared/stores/resource-logo/resource-logo.state";
import {
  ApiService,
  isNotNullNorUndefined,
  isNullOrUndefined,
  NotificationService,
  OverrideDefaultAction,
} from "solidify-frontend";

export const defaultDepositOrganizationalUnitValue: () => DepositOrganizationalUnitStateModel = () =>
  ({
    ...defaultResourceLogoStateInitValue(),
    deposit_organizationalUnit_additionalFieldsForm: defaultDepositOrganizationalUnitAdditionalFieldsFormStateModel(),
  });

export interface DepositOrganizationalUnitStateModel extends ResourceLogoStateModel<OrganizationalUnit> {
  deposit_organizationalUnit_additionalFieldsForm: DepositOrganizationalUnitAdditionalFieldsFormStateModel;
}

@Injectable()
@State<DepositOrganizationalUnitStateModel>({
  name: LocalStateEnum.deposit_organizationalUnit,
  defaults: {
    ...defaultDepositOrganizationalUnitValue(),
  },
  children: [DepositOrganizationalUnitAdditionalFieldsFormState],
})
export class DepositOrganizationalUnitState extends ResourceLogoState<DepositOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              protected readonly _httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositOrganizationalUnitNameSpace,
    }, _httpClient, ResourceLogoStateModeEnum.logo);
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  protected get _urlLogoResource(): string {
    return this._urlResource;
  }

  @Selector()
  static currentTitle(state: DepositOrganizationalUnitStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @OverrideDefaultAction()
  @Action(DepositOrganizationalUnitAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<DepositOrganizationalUnitStateModel>, action: DepositOrganizationalUnitAction.GetByIdSuccess): void {
    ctx.patchState({
      current: action.model,
    });
    if (isNotNullNorUndefined(action.model.logo)) {
      ctx.dispatch(new DepositOrganizationalUnitAction.GetPhoto(action.model.resId));
    } else {
      ctx.patchState({
        logo: undefined,
      });
    }
  }
}
