import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {AdditionalFieldsForm} from "@models";
import {
  Action,
  Actions,
  State, StateContext,
  Store,
} from "@ngxs/store";
import {ApiResourceNameEnum} from "@shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {
  ApiService,
  CompositionState,
  CompositionStateModel,
  defaultCompositionStateInitValue,
  NotificationService, QueryParameters, SolidifyStateError,
} from "solidify-frontend";
import {
  DepositOrganizationalUnitAdditionalFieldsFormAction,
  depositOrganizationalUnitAdditionalFieldsFormActionNameSpace
} from "@deposit/stores/organizational-unit/additional-fields-form/deposit-organizational-unit-additional-fields-form.action";
import {Observable} from "rxjs";
import {catchError, tap} from "rxjs/operators";
import GetCurrentMetadataFormSuccess = DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess;
import GetCurrentMetadataFormFail = DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail;

export const defaultDepositOrganizationalUnitAdditionalFieldsFormStateModel: () => DepositOrganizationalUnitAdditionalFieldsFormStateModel = () =>
  ({
    ...defaultCompositionStateInitValue(),
    queryParameters: new QueryParameters(20),
    loaded: false
  });

export interface DepositOrganizationalUnitAdditionalFieldsFormStateModel extends CompositionStateModel<AdditionalFieldsForm> {
  loaded: boolean;
}

@Injectable()
@State<DepositOrganizationalUnitAdditionalFieldsFormStateModel>({
  name: LocalStateEnum.deposit_organizationalUnit_additionalFieldsForm,
  defaults: {
    ...defaultDepositOrganizationalUnitAdditionalFieldsFormStateModel(),
  },
})
export class DepositOrganizationalUnitAdditionalFieldsFormState extends CompositionState<DepositOrganizationalUnitAdditionalFieldsFormStateModel, AdditionalFieldsForm> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositOrganizationalUnitAdditionalFieldsFormActionNameSpace,
      resourceName: ApiResourceNameEnum.ADDITIONAL_FIELDS_FORM,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @Action(DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataForm)
  getCurrentMetadataForm(ctx: StateContext<DepositOrganizationalUnitAdditionalFieldsFormStateModel>, action: DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataForm): Observable<AdditionalFieldsForm> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1
    });
    return this.apiService.getByIdInPath<AdditionalFieldsForm>(`${this._urlResource}/${action.parentId}/${this._resourceName}/${ApiResourceNameEnum.CURRENT_VERSION}`).pipe(
      tap(result => ctx.dispatch(new GetCurrentMetadataFormSuccess(action, result))),
      catchError(error => {
        ctx.dispatch(new GetCurrentMetadataFormFail(action));
        throw new SolidifyStateError(this, error);
      })
    );
  }

  @Action(DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess)
  getCurrentMetadataFormSuccess(ctx: StateContext<DepositOrganizationalUnitAdditionalFieldsFormStateModel>, action: DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormSuccess): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
      current: action.currentForm,
      loaded: true
    });
  }

  @Action(DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail)
  getCurrentMetadataFormFail(ctx: StateContext<DepositOrganizationalUnitAdditionalFieldsFormStateModel>, action: DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataFormFail): void {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1
    });
  }
}
