import {DepositDataFile} from "@app/features/deposit/models/deposit-data-file.model";
import {FileUploadWrapper} from "@app/features/deposit/models/file-upload-wrapper.model";
import {UploadFileStatus} from "@app/features/deposit/models/upload-file-status.model";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {DepositTabStatusEnum} from "@deposit/enums/deposit-tab-status.enum";
import {Enums} from "@enums";
import {Deposit} from "@models";
import {FileListModel} from "@shared/models/business/file-list.model";
import {Result} from "@shared/models/business/result.model";
import {ResourceLogoNameSpace} from "@shared/stores/resource-logo/resource-logo-namespace.model";
import {ResourceLogoAction} from "@shared/stores/resource-logo/resource-logo.action";
import {
  BaseAction,
  BaseSubAction,
  ErrorDto,
  ResourceAction,
  TypeDefaultAction,
  ValidationErrorDto,
} from "solidify-frontend";

const state = LocalStateEnum.deposit;

export namespace DepositAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<Deposit> {
  }

  @TypeDefaultAction(state)
  export class GetByListId extends ResourceAction.GetByListId {
  }

  @TypeDefaultAction(state)
  export class GetByListIdSuccess extends ResourceAction.GetByListIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetByListIdFail extends ResourceAction.GetByListIdFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<Deposit> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<Deposit> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<Deposit> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<Deposit> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<Deposit> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class AddInList extends ResourceAction.AddInList<Deposit> {
  }

  @TypeDefaultAction(state)
  export class AddInListById extends ResourceAction.AddInListById {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdSuccess extends ResourceAction.AddInListByIdSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdFail extends ResourceAction.AddInListByIdFail<Deposit> {
  }

  @TypeDefaultAction(state)
  export class RemoveInListById extends ResourceAction.RemoveInListById {
  }

  @TypeDefaultAction(state)
  export class RemoveInListByListId extends ResourceAction.RemoveInListByListId {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkList extends ResourceAction.LoadNextChunkList {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListSuccess extends ResourceAction.LoadNextChunkListSuccess<Deposit> {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListFail extends ResourceAction.LoadNextChunkListFail {
  }

  @TypeDefaultAction(state)
  export class Clean extends ResourceAction.Clean {
  }

  @TypeDefaultAction(state)
  export class GetPhoto extends ResourceLogoAction.GetPhoto {
  }

  @TypeDefaultAction(state)
  export class GetPhotoSuccess extends ResourceLogoAction.GetPhotoSuccess {
  }

  @TypeDefaultAction(state)
  export class GetPhotoFail extends ResourceLogoAction.GetPhotoFail {
  }

  @TypeDefaultAction(state)
  export class UploadPhoto extends ResourceLogoAction.UploadPhoto {
  }

  @TypeDefaultAction(state)
  export class UploadPhotoSuccess extends ResourceLogoAction.UploadPhotoSuccess {
  }

  @TypeDefaultAction(state)
  export class UploadPhotoFail extends ResourceLogoAction.UploadPhotoFail {
  }

  @TypeDefaultAction(state)
  export class GetPhotoByResId extends ResourceLogoAction.GetPhotoByResId {
  }

  @TypeDefaultAction(state)
  export class GetPhotoByResIdSuccess extends ResourceLogoAction.GetPhotoByResIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetPhotoByResIdFail extends ResourceLogoAction.GetPhotoByResIdFail {
  }

  @TypeDefaultAction(state)
  export class DeletePhoto extends ResourceLogoAction.DeletePhoto {
  }

  @TypeDefaultAction(state)
  export class DeletePhotoSuccess extends ResourceLogoAction.DeletePhotoSuccess {
  }

  @TypeDefaultAction(state)
  export class DeletePhotoFail extends ResourceLogoAction.DeletePhotoFail {
  }

  export class CheckPhoto {
    static readonly type: string = `[${state}] Check Photo`;

    constructor(public depositId: string) {
    }
  }

  export class Download {
    static readonly type: string = `[${state}] Download`;

    constructor(public id: string, public fullFolderName?: string) {
    }
  }

  export class SetOrganizationalUnit {
    static readonly type: string = `[${state}] Set Organizational Unit`;

    constructor(public organizationalUnitId: string) {
    }
  }

  export class Submit {
    static readonly type: string = `[${state}] Submit`;

    constructor(public deposit: Deposit) {
    }
  }

  export class SubmitSuccess {
    static readonly type: string = `[${state}] Submit Success`;

    constructor(public result: Result) {
    }
  }

  export class SubmitFail {
    static readonly type: string = `[${state}] Submit Fail`;

    constructor(public listValidationError?: ValidationErrorDto[]) {
    }
  }

  export class Approve {
    static readonly type: string = `[${state}] Approve`;

    constructor(public deposit: Deposit) {
    }
  }

  export class ApproveSuccess {
    static readonly type: string = `[${state}] Approve Success`;

    constructor(public result: Result) {
    }
  }

  export class ApproveFail {
    static readonly type: string = `[${state}] Approve Fail`;

    constructor() {
    }
  }

  export class Reject {
    static readonly type: string = `[${state}] Reject`;

    constructor(public deposit: Deposit, public message: string) {
    }
  }

  export class RejectSuccess {
    static readonly type: string = `[${state}] Reject Success`;

    constructor(public result: Result) {
    }
  }

  export class RejectFail {
    static readonly type: string = `[${state}] Reject Fail`;

    constructor() {
    }
  }

  export class BackToEdit {
    static readonly type: string = `[${state}] BackToEdit`;

    constructor(public deposit: Deposit) {
    }
  }

  export class BackToEditSuccess {
    static readonly type: string = `[${state}] BackToEdit Success`;

    constructor(public result: Result) {
    }
  }

  export class BackToEditFail {
    static readonly type: string = `[${state}] BackToEdit Fail`;

    constructor() {
    }
  }

  export class UploadDataFile extends BaseAction {
    static readonly type: string = `[${state}] Upload Data File`;

    constructor(public parentId: string, public fileUploadWrapper: FileUploadWrapper, public isArchive: boolean = false) {
      super();
    }
  }

  export class UploadDataFileSuccess extends BaseSubAction<UploadDataFile> {
    static readonly type: string = `[${state}] Upload Data File Success`;

    constructor(public parentAction: UploadDataFile, public parentId: string, public uploadFileStatus: UploadFileStatus, public depositDataFile: DepositDataFile) {
      super(parentAction);
    }
  }

  export class UploadDataFileFail extends BaseSubAction<UploadDataFile> {
    static readonly type: string = `[${state}] Upload Data File Fail`;

    constructor(public parentAction: UploadDataFile, public uploadFileStatus: UploadFileStatus, public errorDto: ErrorDto | undefined) {
      super(parentAction);
    }
  }

  export class RetrySendDataFile {
    static readonly type: string = `[${state}] Retry Send Data File`;

    constructor(public parentId: string, public uploadFileStatus: UploadFileStatus) {
    }
  }

  export class MarkAsCancelDataFileSending {
    static readonly type: string = `[${state}] Mark As Cancel Data File Sending`;

    constructor(public parentId: string, public uploadFileStatus: UploadFileStatus) {
    }
  }

  export class CancelDataFileSending {
    static readonly type: string = `[${state}] Cancel Data File Sending`;

    constructor(public parentId: string, public uploadFileStatus: UploadFileStatus) {
    }
  }

  export class ReserveDOI {
    static readonly type: string = `[${state}] ReserveDOI`;

    constructor(public deposit: Deposit) {
    }
  }

  export class ReserveDOISuccess {
    static readonly type: string = `[${state}] ReserveDOI Success`;

    constructor(public deposit: Deposit) {
    }
  }

  export class ReserveDOIFail {
    static readonly type: string = `[${state}] ReserveDOI Fail`;

    constructor() {
    }
  }

  export class RefreshAllCounterStatusTab extends BaseAction {
    static readonly type: string = `[${state}] Refresh All Counter Status Tab`;

    constructor(public list: Enums.Deposit.StatusEnum[]) {
      super();
    }
  }

  export class RefreshAllCounterStatusTabSuccess extends BaseSubAction<RefreshAllCounterStatusTab> {
    static readonly type: string = `[${state}] Refresh All Counter Status Tab Success`;
  }

  export class RefreshAllCounterStatusTabFail extends BaseSubAction<RefreshAllCounterStatusTab> {
    static readonly type: string = `[${state}] Refresh All Counter Status Tab Fail`;
  }

  export class RefreshCounterStatusTab extends BaseAction {
    static readonly type: string = `[${state}] Refresh Counter Status Tab`;

    constructor(public status: Enums.Deposit.StatusEnum) {
      super();
    }
  }

  export class RefreshCounterStatusTabSuccess extends BaseSubAction<RefreshCounterStatusTab> {
    static readonly type: string = `[${state}] Refresh Counter Status Tab Success`;

    constructor(public parentAction: RefreshCounterStatusTab, public status: Enums.Deposit.StatusEnum, public counter: number) {
      super(parentAction);
    }
  }

  export class RefreshCounterStatusTabFail extends BaseSubAction<RefreshCounterStatusTab> {
    static readonly type: string = `[${state}] Refresh Counter Status Tab Fail`;
  }

  export class ChangeEditProperty {
    static readonly type: string = `[${state}] Change Edit Property`;

    constructor(public isEditable: boolean) {
    }
  }

  export class GetExcludedListFiles extends BaseAction {
    static readonly type: string = `[${state}] Get Excluded List Files`;
  }

  export class GetExcludedListFilesSuccess extends BaseSubAction<GetExcludedListFiles> {
    static readonly type: string = `[${state}] Get Excluded List Files Success`;

    constructor(public parentAction: GetExcludedListFiles, public fileList: FileListModel) {
      super(parentAction);
    }
  }

  export class GetExcludedListFilesFail extends BaseSubAction<GetExcludedListFiles> {
    static readonly type: string = `[${state}] Get Excluded List Files Fail`;
  }

  export class GetIgnoredListFiles extends BaseAction {
    static readonly type: string = `[${state}] Get Ignored List Files`;
  }

  export class GetIgnoredListFilesSuccess extends BaseSubAction<GetIgnoredListFiles> {
    static readonly type: string = `[${state}] Get Ignored List Files Success`;

    constructor(public parentAction: GetIgnoredListFiles, public fileList: FileListModel) {
      super(parentAction);
    }
  }

  export class GetIgnoredListFilesFail extends BaseSubAction<GetIgnoredListFiles> {
    static readonly type: string = `[${state}] Get Ignored List Files Fail`;
  }

  export class CanCreate extends BaseAction {
    static readonly type: string = `[${state}] Can Create`;

    constructor(public canCreate: boolean) {
      super();
    }
  }

  export class ComputeModeTab extends BaseAction {
    static readonly type: string = `[${state}] Compute Mode Tab`;
  }

  export class SetActiveListTabStatus extends BaseAction {
    static readonly type: string = `[${state}] Set Active List Tab Status`;

    constructor(public activeListTabStatus: DepositTabStatusEnum) {
      super();
    }
  }
}

export const depositActionNameSpace: ResourceLogoNameSpace = DepositAction;
