import {Injectable} from "@angular/core";
import {PreIngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {DepositDataFile} from "@deposit/models/deposit-data-file.model";
import {depositDataFileStatusHistoryNamespace} from "@deposit/stores/data-file/status-history/deposit-data-file-status-history.action";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface DepositDataFileStatusHistoryStateModel extends StatusHistoryStateModel<DepositDataFile> {
}

@Injectable()
@State<DepositDataFileStatusHistoryStateModel>({
  name: LocalStateEnum.deposit_dataFile_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class DepositDataFileStatusHistoryState extends StatusHistoryState<DepositDataFileStatusHistoryStateModel, DepositDataFile> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositDataFileStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.depositDataFile;
  }
}
