import {HttpClient} from "@angular/common/http";
import {Injectable} from "@angular/core";
import {depositDataFileMetadataTypeActionNameSpace} from "@deposit/stores/data-file/metadata-type/deposit-data-file-metadata-type.action";
import {MetadataType} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DownloadService} from "@shared/services/download.service";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface DepositDataFileMetadataTypeStateModel extends ResourceStateModel<MetadataType> {
}

@Injectable()
@State<DepositDataFileMetadataTypeStateModel>({
  name: LocalStateEnum.deposit_dataFile_metadataType,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
})
export class DepositDataFileMetadataTypeState extends ResourceState<DepositDataFileMetadataTypeStateModel, MetadataType> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions,
              protected downloadService: DownloadService,
              protected httpClient: HttpClient) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositDataFileMetadataTypeActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.metadataTypes;
  }
}
