import {DepositDataFile} from "@app/features/deposit/models/deposit-data-file.model";
import {Result} from "@shared/models/business/result.model";
import {
  BaseAction,
  BaseSubAction,
  CompositionAction,
  CompositionNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";
import {LocalStateEnum} from "../../../../shared/enums/local-state.enum";

const state = LocalStateEnum.deposit_dataFile;

export namespace DepositDataFileAction {
  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends CompositionAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends CompositionAction.GetAll {
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends CompositionAction.GetAllSuccess<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends CompositionAction.GetAllFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends CompositionAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends CompositionAction.GetByIdSuccess<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends CompositionAction.GetByIdFail {
  }

  @TypeDefaultAction(state)
  export class Update extends CompositionAction.Update<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends CompositionAction.UpdateSuccess<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends CompositionAction.UpdateFail<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class Create extends CompositionAction.Create<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends CompositionAction.CreateSuccess<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends CompositionAction.CreateFail<DepositDataFile> {
  }

  @TypeDefaultAction(state)
  export class Delete extends CompositionAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends CompositionAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends CompositionAction.DeleteFail {
  }

  export class Resume {
    static readonly type: string = `[${state}] Resume`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
    }
  }

  export class ChangeCurrentFolder {
    static readonly type: string = `[${state}] Change Current Folder`;

    constructor(public newCurrentFolder: string, public refreshNewFolderContent: boolean = false) {
    }
  }

  export class ChangeCurrentCategory {
    static readonly type: string = `[${state}] Change Current Category`;

    constructor(public newCategory: string, public newType: string, public refreshNewCategory: boolean = false) {
    }
  }

  export class Refresh extends BaseAction {
    static readonly type: string = `[${state}] Refresh`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class RefreshSuccess extends BaseSubAction<Refresh> {
    static readonly type: string = `[${state}] Refresh Success`;
  }

  export class RefreshFail extends BaseSubAction<Refresh> {
    static readonly type: string = `[${state}] Refresh Fail`;
  }

  export class Download {
    static readonly type: string = `[${state}] Download`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
    }
  }

  export class GetListFolder extends BaseAction {
    static readonly type: string = `[${state}] Get List Folder`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetListFolderSuccess extends BaseSubAction<GetListFolder> {
    static readonly type: string = `[${state}] Get List Folder Success`;

    constructor(public parentAction: GetListFolder, public folder: string[]) {
      super(parentAction);
    }
  }

  export class GetListFolderFail extends BaseSubAction<GetListFolder> {
    static readonly type: string = `[${state}] Get List Folder Fail`;

    constructor(public parentAction: GetListFolder) {
      super(parentAction);
    }
  }

  export class GetNumberFiles extends BaseAction {
    static readonly type: string = `[${state}] Get Number File`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetNumberFilesSuccess extends BaseSubAction<GetNumberFiles> {
    static readonly type: string = `[${state}] Get Number File Success`;

    constructor(public parentAction: GetNumberFiles, public numberFiles: number) {
      super(parentAction);
    }
  }

  export class GetNumberFilesFail extends BaseSubAction<GetNumberFiles> {
    static readonly type: string = `[${state}] Get Number File Fail`;
  }

  export class GetNumberFilesNotReady extends BaseAction {
    static readonly type: string = `[${state}] Get Number Files Not Ready`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetNumberFilesNotReadySuccess extends BaseSubAction<GetNumberFilesNotReady> {
    static readonly type: string = `[${state}] Get Number Files Not Ready Success`;

    constructor(public parentAction: GetNumberFilesNotReady, public numberFilesNotReady: number) {
      super(parentAction);
    }
  }

  export class GetNumberFilesNotReadyFail extends BaseSubAction<GetNumberFilesNotReady> {
    static readonly type: string = `[${state}] Get Number Files Not Ready Fail`;
  }

  export class GetNumberFilesInError extends BaseAction {
    static readonly type: string = `[${state}] Get Number Files in Error`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetNumberFilesInErrorSuccess extends BaseSubAction<GetNumberFilesInError> {
    static readonly type: string = `[${state}] Get Number Files in Error Success`;

    constructor(public parentAction: GetNumberFilesInError, public numberFilesInErrors: number) {
      super(parentAction);
    }
  }

  export class GetNumberFilesInErrorFail extends BaseSubAction<GetNumberFilesInError> {
    static readonly type: string = `[${state}] Get Number Files in Error Fail`;
  }

  export class GetNumberFilesExcluded extends BaseAction {
    static readonly type: string = `[${state}] Get Number Files Excluded`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetNumberFilesExcludedSuccess extends BaseSubAction<GetNumberFilesExcluded> {
    static readonly type: string = `[${state}] Get Number Files Excluded Success`;

    constructor(public parentAction: GetNumberFilesExcluded, public numberFilesExcluded: number) {
      super(parentAction);
    }
  }

  export class GetNumberFilesExcludedFail extends BaseSubAction<GetNumberFilesExcluded> {
    static readonly type: string = `[${state}] Get Number Files Excluded Fail`;
  }

  export class GetNumberFilesIgnored extends BaseAction {
    static readonly type: string = `[${state}] Get Number Files Ignored`;

    constructor(public parentId: string) {
      super();
    }
  }

  export class GetNumberFilesIgnoredSuccess extends BaseSubAction<GetNumberFilesIgnored> {
    static readonly type: string = `[${state}] Get Number Files Ignored Success`;

    constructor(public parentAction: GetNumberFilesIgnored, public numberFilesIgnored: number) {
      super(parentAction);
    }
  }

  export class GetNumberFilesIgnoredFail extends BaseSubAction<GetNumberFilesIgnored> {
    static readonly type: string = `[${state}] Get Number Files Ignored Fail`;
  }

  export class Validate extends BaseAction {
    static readonly type: string = `[${state}] Validate`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
      super();
    }
  }

  export class ValidateSuccess extends BaseSubAction<Validate> {
    static readonly type: string = `[${state}] Validate Success`;
  }

  export class ValidateFail extends BaseSubAction<Validate> {
    static readonly type: string = `[${state}] Validate Fail`;

    constructor(public parentAction: Validate, public result: Result = undefined) {
      super(parentAction);
    }
  }

  export class Move extends BaseAction {
    static readonly type: string = `[${state}] Move`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
      super();
    }
  }

  export class MoveSuccess extends BaseSubAction<Move> {
    static readonly type: string = `[${state}] Move Success`;

    constructor(public parentAction: Move, public result: DepositDataFile) {
      super(parentAction);
    }
  }

  export class MoveFail extends BaseSubAction<Move> {
    static readonly type: string = `[${state}] Move Fail`;
  }

  export class ChangeDataCategory extends BaseAction {
    static readonly type: string = `[${state}] Change Data Category`;

    constructor(public parentId: string, public dataFile: DepositDataFile) {
      super();
    }
  }

  export class ChangeDataCategorySuccess extends BaseSubAction<ChangeDataCategory> {
    static readonly type: string = `[${state}] Change Data Category Success`;

    constructor(public parentAction: Move, public result: DepositDataFile) {
      super(parentAction);
    }
  }

  export class ChangeDataCategoryFail extends BaseSubAction<ChangeDataCategory> {
    static readonly type: string = `[${state}] Change Data Category Fail`;
  }

  export class DeleteAll extends BaseAction {
    static readonly type: string = `[${state}] Delete All`;

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class DeleteAllSuccess extends BaseSubAction<DeleteAll> {
    static readonly type: string = `[${state}] Delete All Success`;
  }

  export class DeleteAllFail extends BaseSubAction<DeleteAll> {
    static readonly type: string = `[${state}] Delete All Fail`;
  }

  export class ResumeAll extends BaseAction {
    static readonly type: string = `[${state}] Resume All`;

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class ResumeAllSuccess extends BaseSubAction<ResumeAll> {
    static readonly type: string = `[${state}] Resume All Success`;
  }

  export class ResumeAllFail extends BaseSubAction<ResumeAll> {
    static readonly type: string = `[${state}] Resume All Fail`;
  }

  export class ValidateAll extends BaseAction {
    static readonly type: string = `[${state}] Validate All`;

    constructor(public parentId: string, public listResId: string[]) {
      super();
    }
  }

  export class ValidateAllSuccess extends BaseSubAction<ValidateAll> {
    static readonly type: string = `[${state}] Validate All Success`;
  }

  export class ValidateAllFail extends BaseSubAction<ValidateAll> {
    static readonly type: string = `[${state}] Validate All Fail`;
  }

  export class DeleteFolder extends BaseAction {
    static readonly type: string = `[${state}] Delete`;

    constructor(public parentId: string, public fullFolderName?: string) {
      super();
    }
  }

  export class DeleteFolderSuccess extends BaseSubAction<DeleteFolder> {
    static readonly type: string = `[${state}] Delete Folder Success`;
  }

  export class DeleteFolderFail extends BaseSubAction<DeleteFolder> {
    static readonly type: string = `[${state}] Delete Folder Fail`;
  }

}

export const depositDataFileActionNameSpace: CompositionNameSpace = DepositDataFileAction;
