import {Injectable} from "@angular/core";
import {ArchivalStorageResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {depositCollectionStatusHistoryNamespace} from "@deposit/stores/collection/status-history/deposit-collection-status-history.action";
import {Aip} from "@models";

import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  defaultStatusHistoryInitValue,
  StatusHistoryState,
  StatusHistoryStateModel,
} from "@shared/stores/status-history/status-history.state";
import {
  ApiService,
  NotificationService,
} from "solidify-frontend";

export interface DepositCollectionHistoryStateModel extends StatusHistoryStateModel<Aip> {
}

@Injectable()
@State<DepositCollectionHistoryStateModel>({
  name: LocalStateEnum.deposit_collection_statusHistory,
  defaults: {
    ...defaultStatusHistoryInitValue(),
  },
})
export class DepositCollectionStatusHistoryState extends StatusHistoryState<DepositCollectionHistoryStateModel, Aip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositCollectionStatusHistoryNamespace,
    });
  }

  protected get _urlResource(): string {
    return ArchivalStorageResourceApiEnum.aip;
  }
}
