import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {depositAuthorizedOrganizationalUnitNameSpace} from "@deposit/stores/authorized-organizational-unit/deposit-authorized-organizational-unit.action";
import {environment} from "@environments/environment";
import {OrganizationalUnit} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  MappingObjectUtil,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface DepositAuthorizedOrganizationalUnitStateModel extends ResourceStateModel<OrganizationalUnit> {
}

export const defaultDepositAuthorizedOrgUnitValue: () => DepositAuthorizedOrganizationalUnitStateModel = () =>
  ({
    ...defaultResourceStateInitValue(),
    queryParameters: getQueryParameter(),
  });

// WARNING : IN SOME CASE WE NEED TO FILTER TO GET ONLY OPENED ORG UNIT
const getQueryParameter = () => {
  const queryParameters = new QueryParameters(environment.defaultEnumValuePageSizeLazyLoad, {
    field: "name" as keyof OrganizationalUnit,
    order: OrderEnum.ascending,
  });
  MappingObjectUtil.set(queryParameters.search.searchItems, "openOnly", "true");
  return queryParameters;
};

@Injectable()
@State<DepositAuthorizedOrganizationalUnitStateModel>({
  name: LocalStateEnum.deposit_authorizedOrganizationalUnit,
  defaults: {
    ...defaultDepositAuthorizedOrgUnitValue(),
  },
})
export class DepositAuthorizedOrganizationalUnitState extends ResourceState<DepositAuthorizedOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositAuthorizedOrganizationalUnitNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.authorizedOrganizationalUnits;
  }
}
