import {Injectable} from "@angular/core";
import {depositAipActionNameSpace} from "@deposit/stores/aip/deposit-aip.action";
import {Aip} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ArchivalStorageResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface DepositAipStateModel extends ResourceStateModel<Aip> {
}

@Injectable()
@State<DepositAipStateModel>({
  name: LocalStateEnum.deposit_aip,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
})
export class DepositAipState extends ResourceState<DepositAipStateModel, Aip> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: depositAipActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return ArchivalStorageResourceApiEnum.aip;
  }
}
