import {ActivatedRoute} from "@angular/router";
import {
  DepositRoutesEnum,
  RoutesEnum,
} from "@shared/enums/routes.enum";
import {Store} from "@ngxs/store";
import {RouterExtService} from "@shared/services/router-ext.service";

export class DepositHelper {
  static getTabRouteSelected(route: ActivatedRoute): DepositRoutesEnum | undefined {
    const children = route.snapshot.children;
    if (children.length > 0 && children[0].url.length > 0) {
      const mode = children[0].url[0].path;
      return mode as DepositRoutesEnum;
    }
    return undefined;
  }

  static determineMode(store: Store, routerExt: RouterExtService): DepositMode {
    store.selectSnapshot(state => state.router.state.url);
    if (routerExt.getPreviousUrl().includes(RoutesEnum.preservationPlanningDeposit)) {
      return DepositMode.PRESERVATION_PLANNING_DEPOSIT;
    } else {
      return DepositMode.DEPOSIT;
    }
  }
}

export enum DepositMode {
  DEPOSIT = "DEPOSIT",
  PRESERVATION_PLANNING_DEPOSIT = "PRESERVATION_PLANNING_DEPOSIT"
}
