import {DepositDataFile} from "@deposit/models/deposit-data-file.model";
import {ArrayUtil} from "solidify-frontend";

export class DepositDataFileHelper {
  static readonly SEPARATOR: string = "/";
  static readonly ROOT: string = DepositDataFileHelper.SEPARATOR;
  static readonly RELATIVE_LOCATION: keyof DepositDataFile = "relativeLocation";

  static createIntermediateFolders(listFolders: string[]): string[] {
    const listNewIntermediateFolder = [];

    listFolders.forEach(path => {
      if (path === this.ROOT) {
        return;
      }
      this._recursivelyAddParentIfMissing(listFolders, listNewIntermediateFolder, path);
    });
    listFolders.push(...ArrayUtil.distinct(listNewIntermediateFolder));
    if (!listFolders.includes(this.ROOT)) {
      listFolders.push(this.ROOT);
    }
    this._sort(listFolders);
    return listNewIntermediateFolder;
  }

  private static _sort(listFolders: string[]): void {
    listFolders.sort((a, b) => {
      if (a < b) {
        return -1;
      }
      if (a > b) {
        return 1;
      }
      return 0;
    });
  }

  private static _recursivelyAddParentIfMissing(listFolders: string[], listNewIntermediateFolder: string[], path: string): void {
    const lastIndexSeparator = path.lastIndexOf(this.SEPARATOR);
    if (lastIndexSeparator === 0) {
      return;
    }
    const parentPath = path.substring(0, lastIndexSeparator);
    if (!listFolders.includes(parentPath)) {
      listNewIntermediateFolder.push(parentPath);
      this._recursivelyAddParentIfMissing(listFolders, listNewIntermediateFolder, parentPath);
    }
  }
}
