import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {MARK_AS_TRANSLATABLE} from "solidify-frontend";

export enum DepositTabStatusEnum {
  inProgress = "in-progress",
  inValidation = "in-validation",
  approved = "approved",
  completed = "completed",
  rejected = "rejected",
  inError = "in-error",
  all = "all",
}

export class DepositTabStatusName {
  static inProgress: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.inProgress");
  static inValidation: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.inValidation");
  static approved: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.approved");
  static completed: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.completed");
  static rejected: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.rejected");
  static inError: string = MARK_AS_TRANSLATABLE("deposit.tabsStatus.inError");
  static all: string = LabelTranslateEnum.all;
}
