import {NgModule} from "@angular/core";
import {DepositFileUploadDialog} from "@app/features/deposit/components/dialogs/deposit-file-upload/deposit-file-upload.dialog";
import {DepositFilePresentational} from "@app/features/deposit/components/presentationals/deposit-file/deposit-file.presentational";
import {DepositFormPresentational} from "@app/features/deposit/components/presentationals/deposit-form/deposit-form.presentational";
import {DepositListRoutable} from "@app/features/deposit/components/routables/deposit-list/deposit-list.routable";
import {DepositRoutingModule} from "@app/features/deposit/deposit-routing.module";
import {DepositDataFileState} from "@app/features/deposit/stores/data-file/deposit-data-file.state";
import {DepositState} from "@app/features/deposit/stores/deposit.state";
import {DepositPeopleState} from "@app/features/deposit/stores/people/deposit-people.state";
import {SharedModule} from "@app/shared/shared.module";
import {DepositCollectionContainer} from "@deposit/components/containers/deposit-collection/deposit-collection.container";
import {DepositFileContainer} from "@deposit/components/containers/deposit-file/deposit-file.container";
import {DepositUploadContainer} from "@deposit/components/containers/deposit-upload/deposit-upload.container";
import {DepositAipUploadDialog} from "@deposit/components/dialogs/deposit-aip-upload/deposit-aip-upload.dialog";
import {DepositFileChangeDataCategoryDialog} from "@deposit/components/dialogs/deposit-file-change-data-category/deposit-file-change-data-category.dialog";
import {DepositFileMoveDialog} from "@deposit/components/dialogs/deposit-file-move/deposit-file-move.dialog";
import {DepositFileUploadArchiveDialog} from "@deposit/components/dialogs/deposit-file-upload-archive/deposit-file-upload-archive.dialog";
import {DepositOrderAuthorDialog} from "@deposit/components/dialogs/deposit-order-author/deposit-order-author.dialog";
import {DepositPersonAlternativeDialog} from "@deposit/components/dialogs/deposit-person-alternative/deposit-person-alternative.dialog";
import {DepositPersonDialog} from "@deposit/components/dialogs/deposit-person/deposit-person.dialog";
import {DepositRejectDialog} from "@deposit/components/dialogs/deposit-reject/deposit-reject.dialog";
import {DepositCollectionDetailRoutable} from "@deposit/components/routables/deposit-collection-detail/deposit-collection-detail.routable";
import {DepositCollectionRoutable} from "@deposit/components/routables/deposit-collection/deposit-collection.routable";
import {DepositDataRoutable} from "@deposit/components/routables/deposit-data/deposit-data.routable";
import {DepositFileDetailRoutable} from "@deposit/components/routables/deposit-file-detail/deposit-file-detail.routable";
import {DepositFileRoutable} from "@deposit/components/routables/deposit-file/deposit-file.routable";
import {DepositHomeRoutable} from "@deposit/components/routables/deposit-home/deposit-home.routable";
import {DepositMetadataRoutable} from "@deposit/components/routables/deposit-metadata/deposit-metadata.routable";
import {DepositRootRoutable} from "@deposit/components/routables/deposit-root/deposit-root.routable";
import {DepositAipState} from "@deposit/stores/aip/deposit-aip.state";
import {DepositAuthorizedOrganizationalUnitState} from "@deposit/stores/authorized-organizational-unit/deposit-authorized-organizational-unit.state";
import {DepositCollectionState} from "@deposit/stores/collection/deposit-collection.state";
import {DepositCollectionStatusHistoryState} from "@deposit/stores/collection/status-history/deposit-collection-status-history.state";
import {DepositDataFileStatusHistoryState} from "@deposit/stores/data-file/status-history/deposit-data-file-status-history.state";
import {DepositOrganizationalUnitAdditionalFieldsFormState} from "@deposit/stores/organizational-unit/additional-fields-form/deposit-organizational-unit-additional-fields-form.state";
import {DepositOrganizationalUnitState} from "@deposit/stores/organizational-unit/deposit-organizational-unit.state";
import {DepositStatusHistoryState} from "@deposit/stores/status-history/deposit-status-history.state";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {ModuleLoadedEnum} from "@shared/enums/module-loaded.enum";
import {DepositFilesUploadInProgressPresentational} from "./components/presentationals/deposit-files-upload-in-progress/deposit-files-upload-in-progress.presentational";
import {DepositCreateRoutable} from "./components/routables/deposit-create/deposit-create.routable";
import {DepositDetailEditRoutable} from "./components/routables/deposit-detail-edit/deposit-detail-edit.routable";
import {DepositService} from "./services/deposit.service";
import {DepositDataFileMetadataTypeState} from "./stores/data-file/metadata-type/deposit-data-file-metadata-type.state";

const routables = [
  DepositRootRoutable,
  DepositHomeRoutable,
  DepositListRoutable,
  DepositCreateRoutable,
  DepositDetailEditRoutable,
  DepositDataRoutable,
  DepositFileRoutable,
  DepositFileDetailRoutable,
  DepositCollectionRoutable,
  DepositCollectionDetailRoutable,
  DepositMetadataRoutable,
];
const containers = [
  DepositUploadContainer,
  DepositFileContainer,
  DepositCollectionContainer,
];
const dialogs = [
  DepositFileUploadDialog,
  DepositFileUploadArchiveDialog,
  DepositPersonDialog,
  DepositOrderAuthorDialog,
  DepositPersonAlternativeDialog,
  DepositAipUploadDialog,
  DepositFileMoveDialog,
  DepositFileChangeDataCategoryDialog,
  DepositRejectDialog,
];
const presentationals = [
  DepositFormPresentational,
  DepositFilesUploadInProgressPresentational,
  DepositFilePresentational,
];
const states = [
  DepositState,
  DepositDataFileState,
  DepositPeopleState,
  DepositStatusHistoryState,
  DepositDataFileStatusHistoryState,
  DepositDataFileMetadataTypeState,
  DepositOrganizationalUnitState,
  DepositCollectionState,
  DepositCollectionStatusHistoryState,
  DepositAipState,
  DepositAuthorizedOrganizationalUnitState,
  DepositOrganizationalUnitAdditionalFieldsFormState,
];
const services = [
  DepositService,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    DepositRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      ...states,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [
    ...services,
  ],
})
export class DepositModule {
  constructor() {
    window[ModuleLoadedEnum.depositModuleLoaded] = true;
  }
}
