import {
  Component,
  OnInit,
} from "@angular/core";
import {ActivatedRoute} from "@angular/router";
import {AppState} from "@app/stores/app.state";
import {DepositAction} from "@deposit/stores/deposit.action";
import {
  Actions,
  ofActionCompleted,
  Store,
} from "@ngxs/store";
import {SharedAbstractRoutable} from "@shared/components/routables/shared-abstract/shared-abstract.routable";
import {AppRoutesEnum} from "@shared/enums/routes.enum";
import {
  isNullOrUndefined,
  MemoizedUtil,
  StoreUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-home-routable",
  templateUrl: "./deposit-home.routable.html",
  styleUrls: ["./deposit-home.routable.scss"],
})
export class DepositHomeRoutable extends SharedAbstractRoutable implements OnInit {
  private _orgUnitResId: string;

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _route: ActivatedRoute) {
    super();
  }

  ngOnInit(): void {
    if (MemoizedUtil.selectSnapshot(this._store, AppState, state => state.isInTourMode)) {
      return;
    }
    this.retrieveCurrentModelWithUrl();
    this.subscribe(StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(this._store, [
      {
        action: new DepositAction.GetExcludedListFiles(),
        subActionCompletions: [
          this._actions$.pipe(ofActionCompleted(DepositAction.GetExcludedListFilesSuccess)),
          this._actions$.pipe(ofActionCompleted(DepositAction.GetExcludedListFilesFail)),
        ],
      },
      {
        action: new DepositAction.GetIgnoredListFiles(),
        subActionCompletions: [
          this._actions$.pipe(ofActionCompleted(DepositAction.GetIgnoredListFilesSuccess)),
          this._actions$.pipe(ofActionCompleted(DepositAction.GetIgnoredListFilesFail)),
        ],
      },
    ]));
  }

  protected retrieveCurrentModelWithUrl(): void {
    this.retrieveResIdFromUrl();
    this._store.dispatch(new DepositAction.SetOrganizationalUnit(this._orgUnitResId));
  }

  protected retrieveResIdFromUrl(): void {
    this._orgUnitResId = this._route.snapshot.paramMap.get(AppRoutesEnum.paramIdOrgUnitWithoutPrefixParam);
    if (isNullOrUndefined(this._orgUnitResId)) {
      this._orgUnitResId = this._route.parent.snapshot.paramMap.get(AppRoutesEnum.paramIdOrgUnitWithoutPrefixParam);
    }
  }
}

