import {PersonRole} from "@admin/models/person-role.model";
import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {AppState} from "@app/stores/app.state";
import {ModeDepositTabEnum} from "@deposit/enums/mode-deposit-tab.enum";
import {depositActionNameSpace} from "@deposit/stores/deposit.action";
import {
  DepositState,
  DepositStateModel,
} from "@deposit/stores/deposit.state";
import {Enums} from "@enums";
import {Deposit} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditRoutable} from "@shared/components/routables/shared-abstract-detail-edit/shared-abstract-detail-edit.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DepositRoutesEnum} from "@shared/enums/routes.enum";
import {LocalStateModel} from "@shared/models/local-state.model";
import {SecurityService} from "@shared/services/security.service";
import {Observable} from "rxjs";
import {
  distinctUntilChanged,
  tap,
} from "rxjs/operators";
import {MemoizedUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-file-routable",
  templateUrl: "./deposit-file.routable.html",
  styleUrls: ["./deposit-file.routable.scss"],
})
export class DepositFileRoutable extends SharedAbstractDetailEditRoutable<Deposit, DepositStateModel> implements OnInit {
  @Select(AppState.currentOrgUnitPerson) currentPersonObs: Observable<PersonRole>;

  isInDetailMode: boolean = false;

  canEditObs: Observable<boolean> = MemoizedUtil.select(this._store, DepositState, state => state.canEdit);
  depositModeTabEnumObs: Observable<ModeDepositTabEnum> = MemoizedUtil.select(this._store, DepositState, state => state.depositModeTabEnum);

  get depositStatusEnum(): typeof Enums.Deposit.StatusEnum {
    return Enums.Deposit.StatusEnum;
  }

  get modeDepositTabEnum(): typeof ModeDepositTabEnum {
    return ModeDepositTabEnum;
  }

  readonly KEY_PARAM_NAME: keyof Deposit & string;

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog,
              protected readonly _securityService: SecurityService) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.deposit, depositActionNameSpace);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.retrieveResIdFromUrl();
    this.getSubResourceWithParentId(this._resId);

    this.subscribe(this._store.select((s: LocalStateModel) => s.router.state.url)
      .pipe(
        distinctUntilChanged(),
        tap(url => {
          this.isInDetailMode = !url.endsWith(DepositRoutesEnum.files);
          this._changeDetector.detectChanges();
        }),
      ));
  }

  protected getSubResourceWithParentId(id: string): void {
  }
}


