import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  DepositFileChangeDataCategoryDialog,
  DepositFileChangeDataCategoryDialogData,
} from "@deposit/components/dialogs/deposit-file-change-data-category/deposit-file-change-data-category.dialog";
import {
  DepositFileMoveDialog,
  DepositFileMoveDialogData,
} from "@deposit/components/dialogs/deposit-file-move/deposit-file-move.dialog";
import {DepositDataFile} from "@deposit/models/deposit-data-file.model";
import {
  DepositDataFileAction,
  depositDataFileActionNameSpace,
} from "@deposit/stores/data-file/deposit-data-file.action";
import {DepositDataFileState} from "@deposit/stores/data-file/deposit-data-file.state";
import {depositDataFileStatusHistoryNamespace} from "@deposit/stores/data-file/status-history/deposit-data-file-status-history.action";
import {DepositDataFileStatusHistoryState} from "@deposit/stores/data-file/status-history/deposit-data-file-status-history.state";
import {DepositState} from "@deposit/stores/deposit.state";
import {Enums} from "@enums";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {Observable} from "rxjs";
import {
  filter,
  tap,
} from "rxjs/operators";
import {
  isTrue,
  MemoizedUtil,
  OverrideProperty,
} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-file-detail-routable",
  templateUrl: "./deposit-file-detail.routable.html",
  styleUrls: ["../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class DepositFileDetailRoutable extends SharedAbstractFileAipDetailRoutable<DepositDataFile> implements OnInit {
  canEditObs: Observable<boolean> = MemoizedUtil.select(this._store, DepositState, state => state.canEdit);

  @OverrideProperty()
  _extraActions: ExtraButtonToolbar<DepositDataFile>[] = [
    {
      labelToTranslate: (current) => LabelTranslateEnum.doNotIgnore,
      color: "primary",
      icon: IconNameEnum.notIgnore,
      callback: current => this.validate(),
      displayCondition: current => current.status === Enums.DataFile.StatusEnum.IGNORED_FILE,
      order: 54,
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      DepositDataFileState,
      depositDataFileActionNameSpace,
      DepositDataFileStatusHistoryState,
      depositDataFileStatusHistoryNamespace);
  }

  changeDataCategoryWithDialog(): void {
    this.subscribe(this._dialog.open(DepositFileChangeDataCategoryDialog, {
      data: {
        parentResId: this._parentId,
        depositDataFile: this.data.dataFile,
      } as DepositFileChangeDataCategoryDialogData,
    }).afterClosed().pipe(
      filter((result: boolean | undefined) => isTrue(result)),
      tap(result => {
        this._getOrRefreshResource();
      }),
    ));
  }

  moveDataFileWithDialog(): void {
    this.subscribe(this._dialog.open(DepositFileMoveDialog, {
      data: {
        parentResId: this._parentId,
        depositDataFile: this.data.dataFile,
      } as DepositFileMoveDialogData,
    }).afterClosed().pipe(
      filter((result: boolean | undefined) => isTrue(result)),
      tap(result => {
        this._getOrRefreshResource();
      }),
    ));
  }

  validate(): void {
    this._store.dispatch(new DepositDataFileAction.Validate(this._parentId, this.data.dataFile));
  }
}


