import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
  ViewChild,
} from "@angular/core";
import {depositActionNameSpace} from "@app/features/deposit/stores/deposit.action";
import {
  DepositState,
  DepositStateModel,
} from "@app/features/deposit/stores/deposit.state";
import {SharedAbstractCreateRoutable} from "@app/shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {AppPersonState} from "@app/stores/person/app-person.state";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {DepositFormPresentational} from "@deposit/components/presentationals/deposit-form/deposit-form.presentational";
import {DepositOrganizationalUnitAdditionalFieldsFormAction} from "@deposit/stores/organizational-unit/additional-fields-form/deposit-organizational-unit-additional-fields-form.action";
import {DepositOrganizationalUnitAdditionalFieldsFormState} from "@deposit/stores/organizational-unit/additional-fields-form/deposit-organizational-unit-additional-fields-form.state";
import {DepositOrganizationalUnitState} from "@deposit/stores/organizational-unit/deposit-organizational-unit.state";
import {
  AdditionalFieldsForm,
  Deposit,
  Language,
  OrganizationalUnit,
  Person,
  PreservationPolicy,
  SubmissionPolicy,
  SystemProperty,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {DataTestEnum} from "@shared/enums/data-test.enum";
import {IconNameEnum} from "@shared/enums/icon-name.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {SharedLanguageState} from "@shared/stores/language/shared-language.state";
import {SharedOrgUnitPreservationPolicyAction} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.action";
import {SharedOrganizationalUnitPreservationPolicyState} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.state";
import {SharedOrgUnitSubmissionPolicyAction} from "@shared/stores/organizational-unit/submission-policy/shared-organizational-unit-submission-policy.action";
import {SharedOrganizationalUnitSubmissionPolicyState} from "@shared/stores/organizational-unit/submission-policy/shared-organizational-unit-submission-policy.state";
import {SharedPersonState} from "@shared/stores/person/shared-person.state";
import {Observable} from "rxjs";
import {
  distinctUntilChanged,
  filter,
} from "rxjs/operators";
import {
  isNotNullNorUndefined,
  MemoizedUtil,
} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-create-routable",
  templateUrl: "./deposit-create.routable.html",
  styleUrls: ["../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositCreateRoutable extends SharedAbstractCreateRoutable<Deposit, DepositStateModel> implements OnInit, OnDestroy {
  @Select(DepositState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(DepositState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  languagesObs: Observable<Language[]> = MemoizedUtil.list(this._store, SharedLanguageState);
  listPersonObs: Observable<Person[]> = MemoizedUtil.list(this._store, SharedPersonState);
  listPreservationPoliciesObs: Observable<PreservationPolicy[]> = MemoizedUtil.selected(this._store, SharedOrganizationalUnitPreservationPolicyState);
  listSubmissionPoliciesObs: Observable<SubmissionPolicy[]> = MemoizedUtil.selected(this._store, SharedOrganizationalUnitSubmissionPolicyState);
  personConnectedObs: Observable<Person> = MemoizedUtil.current(this._store, AppPersonState);
  additionalFieldsFormObs: Observable<AdditionalFieldsForm> = MemoizedUtil.current(this._store, DepositOrganizationalUnitAdditionalFieldsFormState);
  systemPropertyObs: Observable<SystemProperty> = MemoizedUtil.select(this._store, AppSystemPropertyState, state => state.current);

  @ViewChild("formPresentational")
  readonly formPresentational: DepositFormPresentational;
  orgUnitObs: Observable<OrganizationalUnit> = MemoizedUtil.select(this._store, DepositOrganizationalUnitState, (state) => state.current);
  logoOrgUnitObs: Observable<string> = MemoizedUtil.select(this._store, DepositOrganizationalUnitState, state => state.logo);

  listExtraButtons: ExtraButtonToolbar<Deposit>[] = [
    {
      color: "primary",
      typeButton: "flat-button",
      icon: IconNameEnum.save,
      labelToTranslate: (current) => LabelTranslateEnum.save,
      order: 40,
      dataTest: DataTestEnum.save,
      callback: () => this.formPresentational.onSubmit(),
      displayCondition: (resource) => true,
      disableCondition: () => this.formPresentational?.form?.pristine || this.formPresentational?.form?.invalid || this.formPresentational?.formFormly?.invalid,
    },
  ];

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.deposit, depositActionNameSpace);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.subscribe(this.orgUnitObs.pipe(
      distinctUntilChanged(),
      filter(orgUnit => isNotNullNorUndefined(orgUnit)),
    ), orgUnit => {
      this._store.dispatch(new DepositOrganizationalUnitAdditionalFieldsFormAction.GetCurrentMetadataForm(orgUnit.resId));
      this._store.dispatch(new SharedOrgUnitPreservationPolicyAction.GetAll(orgUnit.resId));
      this._store.dispatch(new SharedOrgUnitSubmissionPolicyAction.GetAll(orgUnit.resId));
    });
  }

  getSubResourceWithParentId(id: string): void {
  }

  ngOnDestroy(): void {
    this._store.dispatch(new SharedOrgUnitPreservationPolicyAction.Clear());
    this._store.dispatch(new SharedOrgUnitSubmissionPolicyAction.Clear());
  }
}
