import {
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {depositCollectionActionNameSpace} from "@deposit/stores/collection/deposit-collection.action";
import {DepositCollectionState} from "@deposit/stores/collection/deposit-collection.state";
import {depositCollectionStatusHistoryNamespace} from "@deposit/stores/collection/status-history/deposit-collection-status-history.action";
import {DepositCollectionStatusHistoryState} from "@deposit/stores/collection/status-history/deposit-collection-status-history.state";
import {DepositState} from "@deposit/stores/deposit.state";
import {Aip} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractFileAipDetailRoutable} from "@shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable";
import {ExtraButtonToolbar} from "@shared/models/extra-button-toolbar.model";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-collection-detail-routable",
  templateUrl: "./deposit-collection-detail.routable.html",
  styleUrls: ["../../../../../shared/components/routables/shared-abstract-file-aip-detail/shared-abstract-file-aip-detail.routable.scss"],
})
export class DepositCollectionDetailRoutable extends SharedAbstractFileAipDetailRoutable<Aip> implements OnInit {
  canEditObs: Observable<boolean> = MemoizedUtil.select(this._store, DepositState, state => state.canEdit);

  @OverrideProperty()
  _extraActions: ExtraButtonToolbar<Aip>[] = [];

  constructor(protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store,
      _route,
      _actions$,
      _dialog,
      _changeDetector,
      DepositCollectionState as any,
      depositCollectionActionNameSpace,
      DepositCollectionStatusHistoryState,
      depositCollectionStatusHistoryNamespace);
  }
}


