import {
  ChangeDetectionStrategy,
  Component,
  Input,
  OnInit,
  Output,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {FileUploadStatusEnum} from "@app/features/deposit/enums/file-upload-status.enum";
import {FileUploadWrapper} from "@app/features/deposit/models/file-upload-wrapper.model";
import {UploadFileStatus} from "@app/features/deposit/models/upload-file-status.model";
import {SharedAbstractPresentational} from "@app/shared/components/presentationals/shared-abstract/shared-abstract.presentational";
import {Guid} from "@app/shared/models/guid.model";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {ObservableUtil} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-files-upload-in-progress",
  templateUrl: "./deposit-files-upload-in-progress.presentational.html",
  styleUrls: ["./deposit-files-upload-in-progress.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositFilesUploadInProgressPresentational extends SharedAbstractPresentational implements OnInit {
  @Input()
  listFilesUploading: UploadFileStatus[];

  private readonly _cancelBS: BehaviorSubject<UploadFileStatus | undefined> = new BehaviorSubject<UploadFileStatus | undefined>(undefined);
  @Output("cancelChange")
  readonly cancelObs: Observable<UploadFileStatus | undefined> = ObservableUtil.asObservable(this._cancelBS);

  private readonly _retryBS: BehaviorSubject<UploadFileStatus | undefined> = new BehaviorSubject<UploadFileStatus | undefined>(undefined);
  @Output("retryChange")
  readonly retryObs: Observable<UploadFileStatus | undefined> = ObservableUtil.asObservable(this._retryBS);

  private readonly _uploadBS: BehaviorSubject<FileUploadWrapper | undefined> = new BehaviorSubject<FileUploadWrapper | undefined>(undefined);
  @Output("uploadChange")
  readonly uploadObs: Observable<FileUploadWrapper | undefined> = ObservableUtil.asObservable(this._uploadBS);

  private readonly _uploadArchiveBS: BehaviorSubject<FileUploadWrapper | undefined> = new BehaviorSubject<FileUploadWrapper | undefined>(undefined);
  @Output("uploadArchiveChange")
  readonly uploadArchiveObs: Observable<FileUploadWrapper | undefined> = ObservableUtil.asObservable(this._uploadArchiveBS);

  constructor(private dialog: MatDialog) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    // TEST CODE FOR DESIGN
    // this.listFilesUploading = [
    //   {
    //     progressPercentage: 10,
    //     status: FileUploadStatusEnum.inProgress,
    //     fileUploadWrapper: {
    //       file: {
    //         name: "Test file name.txt",
    //       } as File,
    //     } as FileUploadWrapper,
    //   } as UploadFileStatus,
    //   {
    //     progressPercentage: 50,
    //     status: FileUploadStatusEnum.inProgress,
    //     fileUploadWrapper: {
    //       file: {
    //         name: "Test file name 2.txt",
    //       } as File,
    //     } as FileUploadWrapper,
    //   } as UploadFileStatus,
    //   {
    //     progressPercentage: 100,
    //     status: FileUploadStatusEnum.completed,
    //     fileUploadWrapper: {
    //       file: {
    //         name: "Test file name completed.txt",
    //       } as File,
    //     } as FileUploadWrapper,
    //   } as UploadFileStatus,
    //   {
    //     progressPercentage: 75,
    //     status: FileUploadStatusEnum.inError,
    //     errorMessageToTranslate: "error.upload.duplicateDataFiles",
    //     fileUploadWrapper: {
    //       file: {
    //         name: "Test file name inError.txt",
    //       } as File,
    //     } as FileUploadWrapper,
    //   } as UploadFileStatus,
    // ];
  }

  getCurrentNumberOfFileInProgress(): number {
    return this.listFilesUploading.filter(f => f.status === FileUploadStatusEnum.inProgress).length;
  }

  cancel(uploadStatus: UploadFileStatus): void {
    this._cancelBS.next(uploadStatus);
  }

  retry(uploadStatus: UploadFileStatus): void {
    this._retryBS.next(uploadStatus);
  }

  trackByFn(index: number, item: UploadFileStatus): Guid {
    return item.guid;
  }
}
