import {NO_ERRORS_SCHEMA} from "@angular/core";
import {
  async,
  ComponentFixture,
  TestBed,
} from "@angular/core/testing";
import {ReactiveFormsModule} from "@angular/forms";
import {MatDialogModule} from "@angular/material/dialog";
import {FileUploadStatusEnum} from "@app/features/deposit/enums/file-upload-status.enum";
import {UploadFileStatus} from "@app/features/deposit/models/upload-file-status.model";
import {MockTranslatePipe} from "../../../../../../test-helpers/mock-translate.pipe";

import {DepositFilePresentational} from "./deposit-file.presentational";

xdescribe("DepositFilePresentational", () => {
  let component: DepositFilePresentational;
  let fixture: ComponentFixture<DepositFilePresentational>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, MatDialogModule],
      declarations: [DepositFilePresentational, MockTranslatePipe],
      schemas: [NO_ERRORS_SCHEMA],
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(DepositFilePresentational);
    component = fixture.componentInstance;
    component.uploadStatus = {
      status: FileUploadStatusEnum.inProgress,
      fileUploadWrapper: {
        file: {
          name: "test_file.txt",
        },
      },
    } as UploadFileStatus;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });
});
