import {
  ChangeDetectionStrategy,
  Component,
  OnInit,
} from "@angular/core";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {
  AbstractControl,
  FormBuilder,
  FormGroup,
  Validators,
} from "@angular/forms";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {PropertyName} from "solidify-frontend";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {MatDialogRef} from "@angular/material/dialog";
import {
  FormValidationHelper,
  SolidifyValidator,
  MemoizedUtil,
} from "solidify-frontend";
import {Observable} from "rxjs/index";
import {DepositState} from "@deposit/stores/deposit.state";

@Component({
  selector: "dlcm-deposit-reject-dialog",
  templateUrl: "./deposit-reject.dialog.html",
  styleUrls: ["./deposit-reject.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositRejectDialog extends SharedAbstractContainer implements OnInit {
  isLoadingObs: Observable<boolean> = MemoizedUtil.isLoading(this._store, DepositState);

  form: FormGroup;
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions,
              private readonly _dialogRef: MatDialogRef<DepositRejectDialog>,
              private readonly _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.form = this._fb.group({
      [this.formDefinition.message]: ["", [Validators.required, SolidifyValidator]],
    });
  }

  close(): void {
    this._dialogRef.close();
  }

  onSubmit(): void {
    this._dialogRef.close(this.form.get(this.formDefinition.message).value);
  }

  getFormControl(key: string): AbstractControl {
    return FormValidationHelper.getFormControl(this.form, key);
  }

  get formValidationHelper(): typeof FormValidationHelper {
    return FormValidationHelper;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() message: string;
}
