import {
  ChangeDetectionStrategy,
  Component,
  Inject,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {Person} from "@models";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-alternative-dialog",
  templateUrl: "./deposit-person-alternative.dialog.html",
  styleUrls: ["./deposit-person-alternative.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositPersonAlternativeDialog extends SharedAbstractContainer {
  selectedDepositPerson: AlternativeDepositPersonSelected;

  constructor(private readonly dialogRef: MatDialogRef<DepositPersonAlternativeDialog>,
              @Inject(MAT_DIALOG_DATA) public data: AlternativeDepositPersonWrapper) {
    super();
  }

  submit(): void {
    this.dialogRef.close(this.selectedDepositPerson);
  }

  select(selected: Person, isNew: boolean): void {
    this.selectedDepositPerson = {
      selected: selected,
      isNew: isNew,
    };
  }

  isSelected(current: Person): boolean {
    if (isNullOrUndefined(this.selectedDepositPerson)) {
      return false;
    }
    return current === this.selectedDepositPerson.selected;
  }
}

export interface AlternativeDepositPersonWrapper {
  newPerson: Person;
  listExistingPerson: Person[];
}

export interface AlternativeDepositPersonSelected {
  selected: Person;
  isNew: boolean;
}
