import {
  CdkDragDrop,
  moveItemInArray,
} from "@angular/cdk/drag-drop";
import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {Person} from "@models";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-order-dialog",
  templateUrl: "./deposit-order-author.dialog.html",
  styleUrls: ["./deposit-order-author.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositOrderAuthorDialog extends SharedAbstractContainer implements OnInit {
  listAuthorsSorted: Person[];

  constructor(protected readonly store: Store,
              protected readonly dialogRef: MatDialogRef<DepositOrderAuthorDialog>,
              @Inject(MAT_DIALOG_DATA) public data: DepositOrderAuthorDialogWrapper) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.listAuthorsSorted = [];
    this.data.authorsId.forEach(id => {
      const author = this.data.persons.find(person => person.resId === id);
      if (isNullOrUndefined(author)) {
        return;
      }
      this.listAuthorsSorted.push(author);
    });
  }

  validate(): void {
    this.dialogRef.close(this.listAuthorsSorted.map(a => a.resId));
  }

  trackByFn(index: number, person: Person): string {
    return person.resId;
  }

  up(index: number, person: Person): void {
    if (index === 0) {
      return;
    }
    this.listAuthorsSorted.splice(index, 1);
    this.listAuthorsSorted.splice(index - 1, 0, person);
  }

  down(index: number, person: Person): void {
    if (index === this.listAuthorsSorted.length) {
      return;
    }
    this.listAuthorsSorted.splice(index, 1);
    this.listAuthorsSorted.splice(index + 1, 0, person);
  }

  drop(event: CdkDragDrop<Person[]>): void {
    if (event.previousContainer === event.container) {
      moveItemInArray(this.listAuthorsSorted, event.previousIndex, event.currentIndex);
    }
  }
}

export interface DepositOrderAuthorDialogWrapper {
  persons: Person[];
  authorsId: string[];
}
