import {
  ChangeDetectionStrategy,
  Component,
} from "@angular/core";
import {FormBuilder} from "@angular/forms";
import {MatDialogRef} from "@angular/material/dialog";
import {FileUploadWrapper} from "@app/features/deposit/models/file-upload-wrapper.model";
import {DataCategoryHelper} from "@app/shared/helpers/data-category.helper";
import {AbstractDepositFileUploadDialog} from "@deposit/components/dialogs/abstract-deposit-file-upload/abstract-deposit-file-upload.dialog";
import {isNullOrUndefined} from "solidify-frontend";

@Component({
  selector: "dlcm-deposit-file-upload-archive-dialog",
  templateUrl: "./deposit-file-upload-archive.dialog.html",
  styleUrls: ["./deposit-file-upload-archive.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class DepositFileUploadArchiveDialog extends AbstractDepositFileUploadDialog {
  archiveToUpload: File;
  isFormValid: boolean = true;

  get dataCategoryHelper(): typeof DataCategoryHelper {
    return DataCategoryHelper;
  }

  constructor(protected _dialogRef: MatDialogRef<DepositFileUploadArchiveDialog>,
              protected _fb: FormBuilder) {
    super(_dialogRef, _fb);
  }

  onFileChange(event: Event & any): void {
    if (event.target.files.length > 0) {
      const files: FileList = event.target.files;
      this.archiveToUpload = files[0];
    }
  }

  onSubmit(): void {
    const base = this.form.value as FileUploadWrapper;
    const fileUploadWrapper = {} as FileUploadWrapper;
    Object.assign(fileUploadWrapper, base);
    fileUploadWrapper.file = this.archiveToUpload;
    this._dialogRef.close(fileUploadWrapper);
  }

  delete(file: File): void {
    this.archiveToUpload = undefined;
  }

  isFileNameInvalid(): boolean {
    if (isNullOrUndefined(this.archiveToUpload)) {
      return false;
    }
    const fileName = this.archiveToUpload.name;
    return this.REGEX_INVALID.test(fileName);
  }

  selectCategory(): void {
    this.isFormValid = false;
  }

  selectDataType(): void {
    this.isFormValid = true;
  }
}
