import {
  Directive,
  OnInit,
} from "@angular/core";
import {
  AbstractControl,
  FormBuilder,
  FormGroup,
  Validators,
} from "@angular/forms";
import {MatDialogRef} from "@angular/material/dialog";
import {SharedAbstractContainer} from "@app/shared/components/containers/shared-abstract/shared-abstract.container";
import {DataCategoryHelper} from "@app/shared/helpers/data-category.helper";
import {BaseFormDefinition} from "@app/shared/models/base-form-definition.model";
import {DepositFileUploadArchiveDialog} from "@deposit/components/dialogs/deposit-file-upload-archive/deposit-file-upload-archive.dialog";
import {DepositFileUploadDialog} from "@deposit/components/dialogs/deposit-file-upload/deposit-file-upload.dialog";
import {depositDataFileMetadataTypeActionNameSpace} from "@deposit/stores/data-file/metadata-type/deposit-data-file-metadata-type.action";
import {DepositDataFileMetadataTypeState} from "@deposit/stores/data-file/metadata-type/deposit-data-file-metadata-type.state";
import {Enums} from "@enums";
import {MetadataType} from "@models";
import {tap} from "rxjs/operators";
import {
  FormValidationHelper,
  PropertyName,
  ResourceNameSpace,
} from "solidify-frontend";

@Directive()
export abstract class AbstractDepositFileUploadDialog extends SharedAbstractContainer implements OnInit {
  form: FormGroup;
  formDefinition: AbstractDepositFileUploadFormComponentFormDefinition = new AbstractDepositFileUploadFormComponentFormDefinition();

  get dataCategoryHelper(): typeof DataCategoryHelper {
    return DataCategoryHelper;
  }

  get dataTypeEnum(): typeof Enums.DataFile.DataTypeEnum {
    return Enums.DataFile.DataTypeEnum;
  }

  getFormControl(key: string): AbstractControl {
    return FormValidationHelper.getFormControl(this.form, key);
  }

  metadataTypeLabelCallback: (value: MetadataType) => string = value => value.fullName;

  readonly REGEX_INVALID: RegExp = new RegExp("[~!@#$%^&*`;?,\\\\]");
  readonly files: string = "files";

  depositDataFileMetadataTypeActionNameSpace: ResourceNameSpace = depositDataFileMetadataTypeActionNameSpace;
  depositDataFileMetadataTypeState: typeof DepositDataFileMetadataTypeState = DepositDataFileMetadataTypeState;

  constructor(protected _dialogRef: MatDialogRef<DepositFileUploadDialog | DepositFileUploadArchiveDialog>,
              protected _fb: FormBuilder) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.form = this._fb.group({
      [this.formDefinition.dataCategory]: [Enums.DataFile.DataCategoryEnum.Primary, [Validators.required]],
      [this.formDefinition.dataType]: [Enums.DataFile.DataTypeEnum.Reference, [Validators.required]],
      [this.formDefinition.metadataType]: [""],
    });

    this.subscribe(this.form.get(this.formDefinition.dataType).valueChanges.pipe(
      tap(value => {
        const metadataFormControl = this.form.get(this.formDefinition.metadataType);
        if (value === Enums.DataFile.DataTypeEnum.CustomMetadata) {
          metadataFormControl.setValidators([Validators.required]);
        } else {
          metadataFormControl.setValidators([]);
        }
        metadataFormControl.updateValueAndValidity();
      }),
    ));
  }

  get formValidationHelper(): typeof FormValidationHelper {
    return FormValidationHelper;
  }

  close(): void {
    this._dialogRef.close();
  }

  abstract onFileChange(event: Event & any): void;

  getDate(lastModified: number): Date {
    return new Date(lastModified);
  }

  abstract onSubmit(): void;

  getDataCategory(): Enums.DataFile.DataCategoryEnum {
    return this.form.get(this.formDefinition.dataCategory).value;
  }

  abstract delete(file: File): void;
}

export class AbstractDepositFileUploadFormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() dataCategory: string;
  @PropertyName() dataType: string;
  @PropertyName() metadataType: string;
}
