import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {
  AdminUserState,
  AdminUserStateModel,
} from "@admin/user/stores/admin-user.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {AppState} from "@app/stores/app.state";
import {User} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RouterExtService} from "@shared/services/router-ext.service";
import {OrderEnum} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-user-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserListRoutable extends SharedAbstractListRoutable<User, AdminUserStateModel> implements OnInit {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof User & string = "externalUid";

  adminUserState: typeof AdminUserState = AdminUserState;

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_user, adminUserActionNameSpace, {}, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
    const currentUser: User = this._store.selectSnapshot(AppState.currentUser);
    this.listNewId = [currentUser.resId];
  }

  conditionDisplayEditButton(model: User | undefined): boolean {
    return true;
  }

  conditionDisplayDeleteButton(model: User | undefined): boolean {
    return true;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "avatar",
        header: LabelTranslateEnum.avatar,
        order: OrderEnum.none,
        resourceNameSpace: adminUserActionNameSpace,
        resourceState: this.adminUserState as any,
        isFilterable: false,
        isSortable: false,
        component: DataTableComponentEnum.logo,
        isUser: true,
      },
      {
        field: "lastName",
        header: LabelTranslateEnum.lastName,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "firstName",
        header: LabelTranslateEnum.firstName,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "email",
        header: LabelTranslateEnum.email,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastLoginTime" as any,
        header: LabelTranslateEnum.lastLoginTime,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }
}
