import {
  AdminUserEditRoleCurrentUserDialog,
  AdminUserEditRoleCurrentUserDialogData,
} from "@admin/user/components/dialogs/admin-user-edit-role-current-user/admin-user-edit-role-current-user.dialog";
import {
  AdminUserAction,
  adminUserActionNameSpace,
} from "@admin/user/stores/admin-user.action";
import {
  AdminUserState,
  AdminUserStateModel,
} from "@admin/user/stores/admin-user.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {AppAction} from "@app/stores/app.action";
import {AppState} from "@app/stores/app.state";
import {
  AccessOrganizationalUnit,
  Person,
  User,
} from "@models";
import {Navigate} from "@ngxs/router-plugin";
import {
  Actions,
  ofActionCompleted,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {SharedPersonState} from "@shared/stores/person/shared-person.state";
import {sharedUserActionNameSpace} from "@shared/stores/user/shared-user.action";
import {
  Observable,
  of,
} from "rxjs";
import {
  take,
  tap,
} from "rxjs/operators";
import {
  isNullOrUndefined,
  isTrue,
  MemoizedUtil,
  ModelFormControlEvent,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-user-detail-edit-routable",
  templateUrl: "./admin-user-detail-edit.routable.html",
  styleUrls: ["./admin-user-detail-edit.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<User, AdminUserStateModel> {
  @Select(AdminUserState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminUserState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;
  listPersonObs: Observable<Person[]> = MemoizedUtil.list(this._store, SharedPersonState);
  listOrgUnitObs: Observable<AccessOrganizationalUnit[]> = MemoizedUtil.list(this._store, SharedOrganizationalUnitState);
  @Select(AppState.currentUser) currentUser: Observable<User>;

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedUserActionNameSpace;

  readonly KEY_PARAM_NAME: keyof User & string = "externalUid";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_user, adminUserActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

  update(model: ModelFormControlEvent<User>): Observable<any> {
    this.subscribe(this.currentUser.pipe(
      take(1),
      tap(currentUser => {
        if (!this.isCurrentUser(currentUser)) {
          super.update(model);
          return;
        }

        const addedRole = model.model.applicationRole?.resId;
        const removedRole = currentUser.applicationRole?.resId;

        if (removedRole === addedRole) {
          super.update(model);
          return;
        }

        this.openModalConfirmEditRole({
          addedRole: addedRole,
          removedRole: removedRole,
        } as AdminUserEditRoleCurrentUserDialogData, model);
      }),
    ));
    return of();
  }

  private openModalConfirmEditRole(data: AdminUserEditRoleCurrentUserDialogData, model: ModelFormControlEvent<User>): void {
    this.subscribe(this._dialog.open(AdminUserEditRoleCurrentUserDialog, {
      data: data,
    }).afterClosed().pipe(
      tap((isConfirmed: boolean | undefined) => {
        if (isNullOrUndefined(isConfirmed)) {
          return;
        }
        if (isTrue(isConfirmed)) {
          this.updateAndLogout(model);
        }
      }),
    ));
  }

  private updateAndLogout(model: ModelFormControlEvent<User>): void {
    super.update(model);
    this.subscribe(this._actions$.pipe(
      ofActionCompleted(AdminUserAction.UpdateSuccess),
      tap((result) => {
        if (isTrue(result.result.successful)) {
          this._store.dispatch(new AppAction.Logout());
        }
      }),
    ));
  }

  isCurrentUser(user: User): boolean {
    if (isNullOrUndefined(user)) {
      return false;
    }
    return user.resId === this._resId;
  }

  navigate($event: string[]): void {
    this._store.dispatch(new Navigate($event));
  }
}
