import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {
  AdminUserState,
  AdminUserStateModel,
} from "@admin/user/stores/admin-user.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {
  AccessOrganizationalUnit,
  Person,
  User,
} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedOrganizationalUnitState} from "@shared/stores/organizational-unit/shared-organizational-unit.state";
import {SharedPersonState} from "@shared/stores/person/shared-person.state";
import {sharedUserActionNameSpace} from "@shared/stores/user/shared-user.action";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-user-create-routable",
  templateUrl: "./admin-user-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserCreateRoutable extends SharedAbstractCreateRoutable<User, AdminUserStateModel> {
  @Select(AdminUserState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminUserState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;
  listPersonObs: Observable<Person[]> = MemoizedUtil.list(this._store, SharedPersonState);
  listOrgUnitObs: Observable<AccessOrganizationalUnit[]> = MemoizedUtil.list(this._store, SharedOrganizationalUnitState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedUserActionNameSpace;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<User>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_user, adminUserActionNameSpace, LocalStateEnum.admin);
  }
}
