import {
  ChangeDetectionStrategy,
  Component,
  Inject,
  OnInit,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialogRef,
} from "@angular/material/dialog";
import {Enums} from "@enums";
import {Store} from "@ngxs/store";
import {SharedAbstractContainer} from "@shared/components/containers/shared-abstract/shared-abstract.container";

@Component({
  selector: "dlcm-admin-user-edit-role-current-user-dialog",
  templateUrl: "./admin-user-edit-role-current-user.dialog.html",
  styleUrls: ["./admin-user-edit-role-current-user.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminUserEditRoleCurrentUserDialog extends SharedAbstractContainer implements OnInit {
  get userApplicationRoleEnum(): typeof Enums.UserApplicationRole.UserApplicationRoleEnum {
    return Enums.UserApplicationRole.UserApplicationRoleEnum;
  }

  constructor(protected store: Store,
              protected dialogRef: MatDialogRef<AdminUserEditRoleCurrentUserDialog>,
              @Inject(MAT_DIALOG_DATA) public data: AdminUserEditRoleCurrentUserDialogData) {
    super();
  }

  ngOnInit(): void {
    super.ngOnInit();
  }

  confirm(): void {
    this.dialogRef.close(true);
  }
}

export interface AdminUserEditRoleCurrentUserDialogData {
  removedRole: string;
  addedRole: string;
}
