import {AdminUserRoutingModule} from "@admin/user/admin-user-routing.module";
import {AdminUserEditRoleCurrentUserDialog} from "@admin/user/components/dialogs/admin-user-edit-role-current-user/admin-user-edit-role-current-user.dialog";
import {AdminUserFormPresentational} from "@admin/user/components/presentationals/admin-user-form/admin-user-form.presentational";
import {AdminUserCreateRoutable} from "@admin/user/components/routables/admin-user-create/admin-user-create.routable";
import {AdminUserDetailEditRoutable} from "@admin/user/components/routables/admin-user-detail-edit/admin-user-detail-edit.routable";
import {AdminUserListRoutable} from "@admin/user/components/routables/admin-user-list/admin-user-list.routable";
import {AdminUserState} from "@admin/user/stores/admin-user.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminUserListRoutable,
  AdminUserDetailEditRoutable,
  AdminUserCreateRoutable,
];
const containers = [];
const dialogs = [
  AdminUserEditRoleCurrentUserDialog,
];
const presentationals = [
  AdminUserFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminUserRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminUserState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminUserModule {
}
