import {AdminUserCreateRoutable} from "@admin/user/components/routables/admin-user-create/admin-user-create.routable";
import {AdminUserDetailEditRoutable} from "@admin/user/components/routables/admin-user-detail-edit/admin-user-detail-edit.routable";
import {AdminUserListRoutable} from "@admin/user/components/routables/admin-user-list/admin-user-list.routable";
import {AdminUserState} from "@admin/user/stores/admin-user.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {ApplicationRoleGuardService} from "@shared/guards/application-role-guard.service";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminUserListRoutable,
    data: {},
    canActivate: [ApplicationRoleGuardService],
  },
  {
    path: AdminRoutesEnum.userDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminUserDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminUserState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.userEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: AdminRoutesEnum.userCreate,
    component: AdminUserCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminUserRoutingModule {
}
