import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {SubmissionPolicy} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-submission-policy-form",
  templateUrl: "./admin-submission-policy-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminSubmissionPolicyFormPresentational extends SharedAbstractFormPresentational<SubmissionPolicy> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected initNewForm(): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: ["", [Validators.required, SolidifyValidator]],
      [this.formDefinition.submissionApproval]: [false, [SolidifyValidator]],
      [this.formDefinition.timeToKeep]: [0, [SolidifyValidator]],
    });
  }

  protected bindFormTo(submissionPolicies: SubmissionPolicy): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [submissionPolicies.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.submissionApproval]: [submissionPolicies.submissionApproval, [SolidifyValidator]],
      [this.formDefinition.timeToKeep]: [submissionPolicies.timeToKeep, [SolidifyValidator]],
    });
  }

  protected treatmentBeforeSubmit(submissionPolicies: SubmissionPolicy): SubmissionPolicy {
    return submissionPolicies;
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() submissionApproval: string;
  @PropertyName() timeToKeep: string;
}
