import {AdminSubmissionPolicyRoutingModule} from "@admin/submission-policy/admin-submission-policy-routing.module";
import {AdminSubmissionPolicyFormPresentational} from "@admin/submission-policy/components/presentationals/admin-submission-policy-form/admin-submission-policy-form.presentational";
import {AdminSubmissionPolicyCreateRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-create/admin-submission-policy-create.routable";
import {AdminSubmissionPolicyDetailEditRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-detail-edit/admin-submission-policy-detail-edit.routable";
import {AdminSubmissionPolicyListRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-list/admin-submission-policy-list.routable";
import {AdminSubmissionPolicyState} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminSubmissionPolicyListRoutable,
  AdminSubmissionPolicyDetailEditRoutable,
  AdminSubmissionPolicyCreateRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminSubmissionPolicyFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminSubmissionPolicyRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminSubmissionPolicyState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminSubmissionPolicyModule {
}
