import {AdminSubmissionPolicyCreateRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-create/admin-submission-policy-create.routable";
import {AdminSubmissionPolicyDetailEditRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-detail-edit/admin-submission-policy-detail-edit.routable";
import {AdminSubmissionPolicyListRoutable} from "@admin/submission-policy/components/routables/admin-submission-policy-list/admin-submission-policy-list.routable";
import {AdminSubmissionPolicyState} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminSubmissionPolicyListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.submissionPolicyDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminSubmissionPolicyDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminSubmissionPolicyState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.submissionPolicyEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
  {
    path: AdminRoutesEnum.submissionPolicyCreate,
    component: AdminSubmissionPolicyCreateRoutable,
    data: {
      breadcrumb: LabelTranslateEnum.create,
    },
    canDeactivate: [CanDeactivateGuard],
  },

];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminSubmissionPolicyRoutingModule {
}
