import {AdminArchiveAclState} from "@admin/archive-acl/stores/admin-archive-acl.state";
import {
  AdminDisseminationPolicyState,
  AdminDisseminationPolicyStateModel,
} from "@admin/dissemination-policy/stores/admin-dissemination-policy.state";
import {
  AdminFundingAgenciesState,
  AdminFundingAgenciesStateModel,
} from "@admin/funding-agencies/stores/admin-funding-agencies.state";
import {
  AdminIndexFieldAliasState,
  AdminIndexFieldAliasStateModel,
} from "@admin/index-field-alias/stores/admin-index-field-alias.state";
import {
  AdminInstitutionState,
  AdminInstitutionStateModel,
} from "@admin/institution/stores/admin-institution.state";
import {
  AdminLanguageState,
  AdminLanguageStateModel,
} from "@admin/language/stores/admin-language.state";
import {
  AdminLicenseState,
  AdminLicenseStateModel,
} from "@admin/license/stores/admin-license.state";
import {
  AdminMetadataTypeState,
  AdminMetadataTypeStateModel,
} from "@admin/metadata-type/stores/admin-metadata-type.state";
import {
  AdminNotificationState,
  AdminNotificationStateModel,
} from "@admin/notification/stores/admin-notification.state";
import {
  AdminOaiSetState,
  AdminOaiSetStateModel,
} from "@admin/oai-set/stores/admin-oai-set.state";
import {
  AdminOAuth2ClientState,
  AdminOAuth2ClientStateModel,
} from "@admin/oauth2-client/stores/admin-oauth2-client.state";
import {
  AdminOrganizationalUnitState,
  AdminOrganizationalUnitStateModel,
} from "@admin/organizational-unit/stores/admin-organizational-unit.state";
import {
  AdminPersonState,
  AdminPersonStateModel,
} from "@admin/person/stores/admin-person.state";
import {
  AdminPreservationPolicyState,
  AdminPreservationPolicyStateModel,
} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {
  AdminResearchDomainState,
  AdminResearchDomainStateModel,
} from "@admin/research-domain/stores/admin-research-domain.state";
import {
  AdminRoleState,
  AdminRoleStateModel,
} from "@admin/role/stores/admin-role.state";
import {
  AdminSubmissionPolicyState,
  AdminSubmissionPolicyStateModel,
} from "@admin/submission-policy/stores/admin-submission-policy.state";
import {
  AdminUserState,
  AdminUserStateModel,
} from "@admin/user/stores/admin-user.state";
import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {
  State,
  Store,
} from "@ngxs/store";
import {BaseStateModel} from "solidify-frontend";

export interface AdminStateModel extends BaseStateModel {
  [LocalStateEnum.admin_submissionPolicy]: AdminSubmissionPolicyStateModel;
  [LocalStateEnum.admin_preservationPolicy]: AdminPreservationPolicyStateModel;
  [LocalStateEnum.admin_license]: AdminLicenseStateModel;
  [LocalStateEnum.admin_organizationalUnit]: AdminOrganizationalUnitStateModel;
  [LocalStateEnum.admin_institution]: AdminInstitutionStateModel;
  [LocalStateEnum.admin_researchDomain]: AdminResearchDomainStateModel;
  [LocalStateEnum.admin_user]: AdminUserStateModel;
  [LocalStateEnum.admin_oaiSet]: AdminOaiSetStateModel;
  [LocalStateEnum.admin_oauth2Client]: AdminOAuth2ClientStateModel;
  [LocalStateEnum.admin_person]: AdminPersonStateModel;
  [LocalStateEnum.admin_role]: AdminRoleStateModel;
  [LocalStateEnum.admin_fundingAgencies]: AdminFundingAgenciesStateModel;
  [LocalStateEnum.admin_indexFieldAlias]: AdminIndexFieldAliasStateModel;
  [LocalStateEnum.admin_archiveAcl]: AdminIndexFieldAliasStateModel;
  [LocalStateEnum.admin_disseminationPolicy]: AdminDisseminationPolicyStateModel;
  [LocalStateEnum.admin_language]: AdminLanguageStateModel;
  [LocalStateEnum.admin_metadataType]: AdminMetadataTypeStateModel;
  [LocalStateEnum.admin_notification]: AdminNotificationStateModel;
}

@Injectable()
@State<AdminStateModel>({
  name: LocalStateEnum.admin,
  defaults: {
    isLoadingCounter: 0,
    [LocalStateEnum.admin_submissionPolicy]: null,
    [LocalStateEnum.admin_preservationPolicy]: null,
    [LocalStateEnum.admin_license]: null,
    [LocalStateEnum.admin_organizationalUnit]: null,
    [LocalStateEnum.admin_institution]: null,
    [LocalStateEnum.admin_researchDomain]: null,
    [LocalStateEnum.admin_user]: null,
    [LocalStateEnum.admin_oaiSet]: null,
    [LocalStateEnum.admin_oauth2Client]: null,
    [LocalStateEnum.admin_person]: null,
    [LocalStateEnum.admin_role]: null,
    [LocalStateEnum.admin_fundingAgencies]: null,
    [LocalStateEnum.admin_indexFieldAlias]: null,
    [LocalStateEnum.admin_archiveAcl]: null,
    [LocalStateEnum.admin_disseminationPolicy]: null,
    [LocalStateEnum.admin_language]: null,
    [LocalStateEnum.admin_metadataType]: null,
    [LocalStateEnum.admin_notification]: null,
  },
  children: [
    AdminSubmissionPolicyState,
    AdminPreservationPolicyState,
    AdminLicenseState,
    AdminOrganizationalUnitState,
    AdminInstitutionState,
    AdminResearchDomainState,
    AdminUserState,
    AdminOaiSetState,
    AdminOAuth2ClientState,
    AdminPersonState,
    AdminRoleState,
    AdminFundingAgenciesState,
    AdminIndexFieldAliasState,
    AdminArchiveAclState,
    AdminDisseminationPolicyState,
    AdminLanguageState,
    AdminMetadataTypeState,
    AdminNotificationState,
  ],
})
export class AdminState {
  constructor(protected store: Store) {
  }
}
