import {adminRoleActionNameSpace} from "@admin/role/stores/admin-role.action";
import {Injectable} from "@angular/core";
import {Role} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  MARK_AS_TRANSLATABLE,
  urlSeparator,
} from "solidify-frontend";

export interface AdminRoleStateModel extends ResourceStateModel<Role> {
}

@Injectable()
@State<AdminRoleStateModel>({
  name: LocalStateEnum.admin_role,
  defaults: {
    ...defaultResourceStateInitValue(),
  },

})
export class AdminRoleState extends ResourceState<AdminRoleStateModel, Role> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminRoleActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminRoleDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminRoleDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminRole,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.roles.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.roles.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.roles.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.roles;
  }

  @Selector()
  static isLoading(state: AdminRoleStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminRoleStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminRoleStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminRoleStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminRoleStateModel): boolean {
    return true;
  }
}
