import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
} from "@angular/core";
import {
  FormBuilder,
  Validators,
} from "@angular/forms";
import {Role} from "@models";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {BaseFormDefinition} from "@shared/models/base-form-definition.model";
import {
  Override,
  PropertyName,
  SolidifyValidator,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-role-form",
  templateUrl: "./admin-role-form.presentational.html",
  styleUrls: ["../../../../../../shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminRoleFormPresentational extends SharedAbstractFormPresentational<Role> {
  formDefinition: FormComponentFormDefinition = new FormComponentFormDefinition();

  constructor(protected readonly _changeDetectorRef: ChangeDetectorRef,
              protected readonly _elementRef: ElementRef,
              private readonly _fb: FormBuilder) {
    super(_changeDetectorRef, _elementRef);
  }

  protected bindFormTo(role: Role): void {
    this.form = this._fb.group({
      [this.formDefinition.name]: [role.name, [Validators.required, SolidifyValidator]],
      [this.formDefinition.level]: [role.level],
    });
  }

  protected initNewForm(): void {
  }

  protected treatmentBeforeSubmit(role: Role): Role {
    role.level = this.model.level;
    return role;
  }

  @Override()
  protected disableSpecificField(): void {
    this.form.get(this.formDefinition.level).disable();
  }
}

class FormComponentFormDefinition extends BaseFormDefinition {
  @PropertyName() name: string;
  @PropertyName() level: string;
}
