import {AdminRoleRoutingModule} from "@admin/role/admin-role-routing.module";
import {AdminRoleFormPresentational} from "@admin/role/components/presentationals/admin-role-form/admin-role-form.presentational";
import {AdminRoleDetailEditRoutable} from "@admin/role/components/routables/admin-role-detail-edit/admin-role-detail-edit.routable";
import {AdminRoleListRoutable} from "@admin/role/components/routables/admin-role-list/admin-role-list.routable";
import {AdminRoleState} from "@admin/role/stores/admin-role.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminRoleListRoutable,
  AdminRoleDetailEditRoutable,
];
const containers = [];
const dialogs = [];
const presentationals = [
  AdminRoleFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminRoleRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminRoleState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminRoleModule {
}
