import {AdminRoleDetailEditRoutable} from "@admin/role/components/routables/admin-role-detail-edit/admin-role-detail-edit.routable";
import {AdminRoleListRoutable} from "@admin/role/components/routables/admin-role-list/admin-role-list.routable";
import {AdminRoleState} from "@admin/role/stores/admin-role.state";
import {NgModule} from "@angular/core";
import {
  RouterModule,
  Routes,
} from "@angular/router";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  AdminRoutesEnum,
  AppRoutesEnum,
} from "@shared/enums/routes.enum";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";

const routes: Routes = [
  {
    path: AppRoutesEnum.root,
    component: AdminRoleListRoutable,
    data: {},
  },
  {
    path: AdminRoutesEnum.roleDetail + AppRoutesEnum.separator + AppRoutesEnum.paramId,
    component: AdminRoleDetailEditRoutable,
    data: {
      breadcrumbMemoizedSelector: AdminRoleState.currentTitle,
    },
    children: [
      {
        path: AdminRoutesEnum.roleEdit,
        data: {
          breadcrumb: LabelTranslateEnum.edit,
        },
        canDeactivate: [CanDeactivateGuard],
      },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class AdminRoleRoutingModule {
}
