import {
  AdminResearchDomainAction,
  adminResearchDomainActionNameSpace,
} from "@admin/research-domain/stores/admin-research-domain.action";
import {Injectable} from "@angular/core";
import {DepositStateModel} from "@deposit/stores/deposit.state";
import {ResearchDomain} from "@models";
import {
  Action,
  Actions,
  ofActionCompleted,
  Selector,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {SharedLanguageAction} from "@shared/stores/language/shared-language.action";
import {Observable} from "rxjs";
import {tap} from "rxjs/operators";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface AdminResearchDomainStateModel extends ResourceStateModel<ResearchDomain> {

}

@Injectable()
@State<AdminResearchDomainStateModel>({
  name: LocalStateEnum.admin_researchDomain,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
})
export class AdminResearchDomainState extends ResourceState<AdminResearchDomainStateModel, ResearchDomain> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminResearchDomainActionNameSpace,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminResearchDomain,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.researchDomain.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.researchDomain.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.researchDomain.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.researchDomains;
  }

  @Selector()
  static isLoading(state: AdminResearchDomainStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminResearchDomainStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminResearchDomainStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminResearchDomainStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminResearchDomainStateModel): boolean {
    return true;
  }

  @Action(AdminResearchDomainAction.LoadResource)
  loadResource(ctx: StateContext<DepositStateModel>, action: AdminResearchDomainAction.LoadResource): Observable<any> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    return StoreUtil.dispatchParallelActionAndWaitForSubActionsCompletion(ctx, [
      {
        action: new SharedLanguageAction.GetAll(null, false, false),
        subActionCompletions: [
          this.actions$.pipe(ofActionCompleted(SharedLanguageAction.GetAllSuccess)),
          this.actions$.pipe(ofActionCompleted(SharedLanguageAction.GetAllFail)),
        ],
      },
    ]).pipe(
      tap(success => {
        if (success) {
          ctx.dispatch(new AdminResearchDomainAction.LoadResourceSuccess(action));
        } else {
          ctx.dispatch(new AdminResearchDomainAction.LoadResourceFail(action));
        }
      }),
    );
  }
}
