import {AdminResearchDomainCreateEditDialog} from "@admin/research-domain/components/dialogs/admin-research-domain-create-edit/admin-research-domain-create-edit.dialog";
import {adminResearchDomainActionNameSpace} from "@admin/research-domain/stores/admin-research-domain.action";
import {AdminResearchDomainStateModel} from "@admin/research-domain/stores/admin-research-domain.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ElementRef,
  OnInit,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Language,
  ResearchDomain,
} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractListRoutable} from "@shared/components/routables/shared-abstract-list/shared-abstract-list.routable";
import {DataTableComponentEnum} from "@shared/enums/data-table-component.enum";
import {FieldTypeEnum} from "@shared/enums/field-type.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {DataTableColumns} from "@shared/models/data-table-columns.model";
import {CreateEditDialog} from "@shared/models/detail-edit-dialog.model";
import {RouterExtService} from "@shared/services/router-ext.service";
import {SharedLanguageAction} from "@shared/stores/language/shared-language.action";
import {SharedLanguageState} from "@shared/stores/language/shared-language.state";
import {Observable} from "rxjs";
import {
  filter,
  take,
  tap,
} from "rxjs/operators";
import {
  isNullOrUndefined,
  isTrue,
  isTruthyObject,
  MARK_AS_TRANSLATABLE,
  MemoizedUtil,
  OrderEnum,
  Override,
} from "solidify-frontend";

@Component({
  selector: "dlcm-admin-research-domain-list-routable",
  templateUrl: "../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-list/shared-abstract-list.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminResearchDomainListRoutable extends SharedAbstractListRoutable<ResearchDomain, AdminResearchDomainStateModel> implements OnInit {
  readonly KEY_CREATE_BUTTON: string = LabelTranslateEnum.create;
  readonly KEY_BACK_BUTTON: string | undefined = LabelTranslateEnum.backToAdmin;
  readonly KEY_PARAM_NAME: keyof ResearchDomain & string = "name";

  languagesObs: Observable<Language[]> = MemoizedUtil.list(this._store, SharedLanguageState);

  constructor(protected readonly _store: Store,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _route: ActivatedRoute,
              protected readonly _routerExt: RouterExtService,
              protected readonly _actions$: Actions,
              protected readonly _dialog: MatDialog) {
    super(_store, _changeDetector, _route, _routerExt, _actions$, _dialog, LocalStateEnum.admin_researchDomain, adminResearchDomainActionNameSpace, {}, LocalStateEnum.admin);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this._store.dispatch(new SharedLanguageAction.GetAll());
    this.subscribe(this.languagesObs.pipe(
      filter(languages => !isNullOrUndefined(languages)),
      take(1),
      ),
      languages => this.addLanguagesColumns(languages));
  }

  conditionDisplayEditButton(model: ResearchDomain | undefined): boolean {
    return true;
  }

  conditionDisplayDeleteButton(model: ResearchDomain | undefined): boolean {
    return true;
  }

  defineColumns(): void {
    this.columns = [
      {
        field: "code",
        header: LabelTranslateEnum.code,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
        width: "100px",
      },
      {
        field: "name",
        header: LabelTranslateEnum.nameLabel,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "source" as any,
        header: LabelTranslateEnum.source,
        type: FieldTypeEnum.string,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "creation.when" as any,
        header: LabelTranslateEnum.created,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.none,
        isFilterable: true,
        isSortable: true,
      },
      {
        field: "lastUpdate.when" as any,
        header: LabelTranslateEnum.updated,
        type: FieldTypeEnum.datetime,
        order: OrderEnum.descending,
        isFilterable: true,
        isSortable: true,
      },
    ];
  }

  private addLanguagesColumns(listLanguages: Language[]): void {
    const languagesColumn: DataTableColumns<ResearchDomain>[] = [];
    listLanguages.forEach(language => {
      languagesColumn.push({
        field: language.resId as any,
        header: MARK_AS_TRANSLATABLE(language.resId),
        order: OrderEnum.none,
        component: DataTableComponentEnum.adminResearchDomainLabel,
      });
    });
    this.columns = [...this.columns, ...languagesColumn];
  }

  @Override()
  create(element: ElementRef): void {
    this.subscribe(this._dialog.open(AdminResearchDomainCreateEditDialog, {
      minWidth: "500px",
      data: {
        current: undefined,
      } as CreateEditDialog<ResearchDomain>,
    }).afterClosed().pipe(
      tap((isConfirmed: boolean | undefined) => {
        if (isNullOrUndefined(isConfirmed)) {
          if (isTruthyObject(element)) {
            element.nativeElement.focus();
          }
          return;
        }
        if (isTrue(isConfirmed)) {
          if (isTruthyObject(element)) {
            element.nativeElement.focus();
          }
          this.getAll();
        }
      }),
    ));
  }

  @Override()
  goToEdit(model: ResearchDomain): void {
    this.subscribe(this._dialog.open(AdminResearchDomainCreateEditDialog, {
      minWidth: "500px",
      data: {
        current: model,
      } as CreateEditDialog<ResearchDomain>,
    }).afterClosed().pipe(
      tap((isConfirmed: boolean | undefined) => {
        if (isNullOrUndefined(isConfirmed)) {
          return;
        }
        if (isTrue(isConfirmed)) {
          this.getAll();
        }
      }),
    ));
  }

  @Override()
  showDetail(model: ResearchDomain): void {
    this.goToEdit(model);
  }
}
