import {adminResearchDomainActionNameSpace} from "@admin/research-domain/stores/admin-research-domain.action";
import {AdminResearchDomainStateModel} from "@admin/research-domain/stores/admin-research-domain.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Inject,
} from "@angular/core";
import {
  MAT_DIALOG_DATA,
  MatDialog,
  MatDialogRef,
} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {
  Language,
  ResearchDomain,
} from "@models";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {SharedAbstractCreateEditDialog} from "@shared/components/dialogs/shared-abstract-create-edit/shared-abstract-create-edit.dialog";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {CreateEditDialog} from "@shared/models/detail-edit-dialog.model";
import {SharedLanguageState} from "@shared/stores/language/shared-language.state";
import {sharedResearchDomainActionNameSpace} from "@shared/stores/research-domain/shared-research-domain.action";
import {Observable} from "rxjs";
import {
  MemoizedUtil,
  OverrideProperty,
  ResourceNameSpace,
} from "solidify-frontend";

@Component({
  selector: "dlcm-research-domain-create-edit-dialog",
  templateUrl: "./admin-research-domain-create-edit.dialog.html",
  styleUrls: ["./admin-research-domain-create-edit.dialog.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminResearchDomainCreateEditDialog extends SharedAbstractCreateEditDialog<ResearchDomain, AdminResearchDomainStateModel> {
  languagesObs: Observable<Language[]> = MemoizedUtil.list(this._store, SharedLanguageState);

  @OverrideProperty()
  checkAvailableResourceNameSpace: ResourceNameSpace = sharedResearchDomainActionNameSpace;

  constructor(@Inject(MAT_DIALOG_DATA) protected readonly data: CreateEditDialog<ResearchDomain>,
              protected readonly _store: Store,
              protected readonly _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              protected readonly _dialog: MatDialog,
              protected readonly _dialogRef: MatDialogRef<AdminResearchDomainCreateEditDialog>) {
    super(data, _store, _route, _actions$, _changeDetector, _dialog, _dialogRef, LocalStateEnum.admin_researchDomain, adminResearchDomainActionNameSpace, LocalStateEnum.admin);

  }

  getSubResourceWithParentId(id: string): void {
  }

  readonly KEY_CANCEL_BUTTON: string | undefined;
  readonly KEY_CREATE_BUTTON: string;
  readonly KEY_CREATE_TITLE: string | undefined;
  readonly KEY_UPDATE_BUTTON: string;
  readonly KEY_UPDATE_TITLE: string | undefined;
}
