import {AdminResearchDomainRoutingModule} from "@admin/research-domain/admin-research-domain-routing.module";
import {AdminResearchDomainCreateEditDialog} from "@admin/research-domain/components/dialogs/admin-research-domain-create-edit/admin-research-domain-create-edit.dialog";
import {AdminResearchDomainFormPresentational} from "@admin/research-domain/components/presentationals/admin-research-domain-form/admin-research-domain-form.presentational";
import {AdminResearchDomainListRoutable} from "@admin/research-domain/components/routables/admin-research-domain-list/admin-research-domain-list.routable";
import {AdminResearchDomainState} from "@admin/research-domain/stores/admin-research-domain.state";
import {NgModule} from "@angular/core";
import {SharedModule} from "@app/shared/shared.module";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";

const routables = [
  AdminResearchDomainListRoutable,
];
const containers = [];
const dialogs = [
  AdminResearchDomainCreateEditDialog,
];
const presentationals = [
  AdminResearchDomainFormPresentational,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
  ],
  imports: [
    SharedModule,
    AdminResearchDomainRoutingModule,
    TranslateModule.forChild({}),
    NgxsModule.forFeature([
      AdminResearchDomainState,
    ]),
  ],
  entryComponents: [
    ...dialogs,
  ],
  exports: [
    ...routables,
  ],
  providers: [],
})
export class AdminResearchDomainModule {
}
