import {Injectable} from "@angular/core";
import {PreservationPolicy} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {RoutesEnum} from "@shared/enums/routes.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  NotificationService,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  MARK_AS_TRANSLATABLE,
  urlSeparator,
} from "solidify-frontend";
import {adminPreservationPolicyActionNameSpace} from "./admin-preservation-policy.action";

export interface AdminPreservationPolicyStateModel extends ResourceStateModel<PreservationPolicy> {
}

@Injectable()
@State<AdminPreservationPolicyStateModel>({
  name: LocalStateEnum.admin_preservationPolicy,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
})
export class AdminPreservationPolicyState extends ResourceState<AdminPreservationPolicyStateModel, PreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: adminPreservationPolicyActionNameSpace,
      routeRedirectUrlAfterSuccessCreateAction: (resId: string) => RoutesEnum.adminPreservationPolicyDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessUpdateAction: (resId: string) => RoutesEnum.adminPreservationPolicyDetail + urlSeparator + resId,
      routeRedirectUrlAfterSuccessDeleteAction: RoutesEnum.adminPreservationPolicy,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.preservationPolicy.notification.resource.create"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.preservationPolicy.notification.resource.delete"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("admin.preservationPolicy.notification.resource.update"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.preservationPolicies;
  }

  @Selector()
  static isLoading(state: AdminPreservationPolicyStateModel): boolean {
    return StoreUtil.isLoadingState(state);
  }

  @Selector()
  static isLoadingWithDependency(state: AdminPreservationPolicyStateModel): boolean {
    return this.isLoading(state);
  }

  @Selector()
  static currentTitle(state: AdminPreservationPolicyStateModel): string | undefined {
    if (isNullOrUndefined(state.current)) {
      return undefined;
    }
    return state.current.name;
  }

  @Selector()
  static isReadyToBeDisplayed(state: AdminPreservationPolicyStateModel): boolean {
    return this.isReadyToBeDisplayedInCreateMode
      && !isNullOrUndefined(state.current);
  }

  @Selector()
  static isReadyToBeDisplayedInCreateMode(state: AdminPreservationPolicyStateModel): boolean {
    return true;
  }
}
