import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {
  AdminPreservationPolicyState,
  AdminPreservationPolicyStateModel,
} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
} from "@angular/core";
import {MatDialog} from "@angular/material/dialog";
import {ActivatedRoute} from "@angular/router";
import {PreservationPolicy} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractDetailEditCommonRoutable} from "@shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-preservation-policy-detail-edit-routable",
  templateUrl: "./admin-preservation-policy-detail-edit.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-detail-edit-common/shared-abstract-detail-edit-common.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyDetailEditRoutable extends SharedAbstractDetailEditCommonRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  @Select(AdminPreservationPolicyState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminPreservationPolicyState.isReadyToBeDisplayed) isReadyToBeDisplayedObs: Observable<boolean>;

  readonly KEY_PARAM_NAME: keyof PreservationPolicy & string = "name";

  constructor(protected _store: Store,
              protected _route: ActivatedRoute,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef,
              public _dialog: MatDialog) {
    super(_store, _route, _actions$, _changeDetector, _dialog, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, LocalStateEnum.admin);
  }

  getSubResourceWithParentId(id: string): void {
  }

}
