import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {
  AdminPreservationPolicyState,
  AdminPreservationPolicyStateModel,
} from "@admin/preservation-policy/stores/admin-preservation-policy.state";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewChild,
} from "@angular/core";
import {PreservationPolicy} from "@models";
import {
  Actions,
  Select,
  Store,
} from "@ngxs/store";
import {SharedAbstractFormPresentational} from "@shared/components/presentationals/shared-abstract-form/shared-abstract-form.presentational";
import {SharedAbstractCreateRoutable} from "@shared/components/routables/shared-abstract-create/shared-abstract-create.routable";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {Observable} from "rxjs";

@Component({
  selector: "dlcm-admin-preservation-policy-create-routable",
  templateUrl: "./admin-preservation-policy-create.routable.html",
  styleUrls: ["../../../../../../shared/components/routables/shared-abstract-create/shared-abstract-create.routable.scss"],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AdminPreservationPolicyCreateRoutable extends SharedAbstractCreateRoutable<PreservationPolicy, AdminPreservationPolicyStateModel> {
  @Select(AdminPreservationPolicyState.isLoadingWithDependency) isLoadingWithDependencyObs: Observable<boolean>;
  @Select(AdminPreservationPolicyState.isReadyToBeDisplayedInCreateMode) isReadyToBeDisplayedInCreateModeObs: Observable<boolean>;

  @ViewChild("formPresentational")
  readonly formPresentational: SharedAbstractFormPresentational<PreservationPolicy>;

  constructor(protected readonly _store: Store,
              protected readonly _actions$: Actions,
              protected readonly _changeDetector: ChangeDetectorRef) {
    super(_store, _actions$, _changeDetector, LocalStateEnum.admin_preservationPolicy, adminPreservationPolicyActionNameSpace, LocalStateEnum.admin);
  }
}
